/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.utils;

import android.content.Context;
import android.net.Uri;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.utils.JsonBuilder;
import java.util.TimeZone;
import org.json.JSONException;

public class RestUtils {
    public static String getAuthority(Context context) {
        int region = ConfigurationProvider.getInstance(context).getDataRegion();
        if (region == -999) {
            return "apiv2.moengage.com";
        }
        switch (region) {
            case 1003: {
                return "apiv2.moengage.com";
            }
            case 1002: {
                return "apiv2eu.moengage.com";
            }
            case 1001: {
                return "apiv2mumbai.moengage.com";
            }
        }
        return "apiv2.moengage.com";
    }

    public static RequestBuilder getBaseRequestBuilder(Uri uri, RequestBuilder.RequestType requestType, String appId) {
        return new RequestBuilder(uri, requestType).addHeader("MOE-APPKEY", appId);
    }

    public static JsonBuilder getDefaultParams(Context context) throws JSONException {
        JsonBuilder params = new JsonBuilder();
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        long currentTime = MoEUtils.currentTime();
        params.putString("os", "ANDROID").putString("app_id", MoEUtils.getAppId(context)).putString("sdk_ver", String.valueOf(9402)).putString("unique_id", provider.getCurrentUserId()).putLong("device_ts", currentTime).putLong("device_tz_offset", TimeZone.getDefault().getOffset(currentTime)).putString("app_ver", Integer.toString(provider.getAppVersion()));
        if (provider.isSegmentEnabled()) {
            params.putString("integration_type", "segment");
        }
        if (!provider.isDataTrackingOptedOut()) {
            params.putString("app_version_name", provider.getAppVersionName());
        }
        params.putString("moe_push_ser", ConfigurationCache.getInstance().getPushService());
        return params;
    }

    public static Uri.Builder getBaseUriBuilder(Context context) {
        return new Uri.Builder().scheme("https").encodedAuthority(RestUtils.getAuthority(context));
    }
}

