/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.mipush;

import android.app.Application;
import com.moengage.core.Logger;
import com.moengage.core.mipush.MiPushHandler;

public class MiPushManager {
    private static final String TAG = "MiPushManager";
    private MiPushHandler miPushHandler;
    private static MiPushManager _INSTANCE;

    private MiPushManager() {
        this.loadHandler();
    }

    private void loadHandler() {
        try {
            Class<?> handler = Class.forName("com.moengage.mi.MiPushHandlerImpl");
            this.miPushHandler = (MiPushHandler)handler.newInstance();
        }
        catch (Exception e) {
            Logger.e("MiPushManager loadHandler() : Did not find Mi Push Module. ", e);
        }
    }

    public static MiPushManager getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new MiPushManager();
        }
        return _INSTANCE;
    }

    public void initMiPush(Application application) {
        if (this.miPushHandler != null) {
            this.miPushHandler.initMiPushIfRequired(application);
        }
    }
}

