/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.rest;

import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.exceptions.UTF8EncodingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class RestClient {
    private static final String TAG = "RestClient";
    private Request request;
    private static final String ENCODING_CHARSET_UTF8 = "UTF-8";
    private static final String CHARACTER_SET = "Accept-Charset";
    private static final String CONTENT_TYPE = "Content-type";

    public RestClient(Request request) {
        this.request = request;
    }

    @Nullable
    public Response executeRequest() throws UTF8EncodingException, IOException, MalformedURLException {
        return this.execute();
    }

    private Response execute() throws IOException {
        String urlString = this.request.getUrl().toString();
        URL url = new URL(urlString);
        Logger.v("RestClient execute(): Request url: " + url.toString());
        HttpURLConnection urlConnection = "https".equals(this.request.getUrl().getScheme()) ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
        this.addHeaders(urlConnection, this.request.getHeadersMap());
        this.setContentType(urlConnection, this.request.getContentType());
        this.setRequestType(urlConnection, this.request.getRequestType());
        if (this.request.getRequestType() == RequestBuilder.RequestType.POST || this.request.getRequestType() == RequestBuilder.RequestType.PUT) {
            this.addBody(urlConnection, this.request.getRequestBody());
        }
        Response response = new Response();
        int responseCode = urlConnection.getResponseCode();
        Logger.v("RestClient execute(): Response Code: " + responseCode);
        response.setResponseCode(responseCode);
        if (responseCode == 200) {
            String responseBody = this.convertStreamToString(urlConnection.getInputStream());
            Logger.v("RestClient execute(): Response Body: " + responseBody);
            response.setResponseBody(responseBody);
        } else {
            String errorResponse = this.convertStreamToString(urlConnection.getErrorStream());
            Logger.f("RestClient Response: API Failed: " + url + " response code :" + responseCode + "reason : " + errorResponse);
            response.setErrorMessage(errorResponse);
        }
        urlConnection.disconnect();
        return response;
    }

    private void setContentType(HttpURLConnection urlConnection, String contentType) {
        urlConnection.setRequestProperty(CONTENT_TYPE, contentType);
    }

    private void setRequestType(HttpURLConnection urlConnection, RequestBuilder.RequestType requestType) throws ProtocolException {
        urlConnection.setRequestMethod(requestType.toString());
    }

    private void addBody(HttpURLConnection urlConnection, JSONObject requestBody) throws IOException {
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty(CHARACTER_SET, ENCODING_CHARSET_UTF8);
        urlConnection.setRequestProperty(CONTENT_TYPE, "application/json");
        OutputStream output = urlConnection.getOutputStream();
        if (requestBody != null) {
            Logger.v("RestClient addBody(): Request Body: " + requestBody.toString());
            output.write(requestBody.toString().getBytes(ENCODING_CHARSET_UTF8));
        }
        output.close();
    }

    private void addHeaders(HttpURLConnection urlConnection, Map<String, String> headers) {
        Set<Map.Entry<String, String>> headerMap = headers.entrySet();
        for (Map.Entry<String, String> header : headerMap) {
            Logger.v("RestClient addHeaders(): " + header.getKey() + " : " + header.getValue());
            urlConnection.addRequestProperty(header.getKey(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }
}

