/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEAttribute;
import org.json.JSONObject;

class SetAliasTask
extends SDKTask {
    private static final String TAG = "SetAliasTask";
    private JSONObject aliasJSON;

    SetAliasTask(Context context, JSONObject aliasJSON) {
        super(context);
        this.aliasJSON = aliasJSON;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("SetAliasTask: executing alias task");
            MoEAttribute aliasAttribute = MoEUtils.convertJsonToAttributeObject(this.aliasJSON);
            String savedUniqueId = MoEUtils.getUserAttributeUniqueId(this.mContext);
            if (savedUniqueId == null || aliasAttribute == null) {
                MoEDispatcher.getInstance(this.mContext).getAttributeManager().setUserAttribute(this.aliasJSON);
                return null;
            }
            if (savedUniqueId.equals(aliasAttribute.getValue())) {
                Logger.v("SetAliasTask execute() current unique id same as same existing no need to update");
                return null;
            }
            if (!MoEDispatcher.getInstance(this.mContext).getCoreEvaluator().isValidUniqueId(ConfigurationProvider.getInstance(this.mContext).getBlockedUniqueIdRegex(), aliasAttribute.getValue())) {
                Logger.e("SetAliasTask execute() : Not a valid unique id. Tracked Value: " + aliasAttribute.getValue());
                return null;
            }
            MoEDAO.getInstance(this.mContext).saveUserAttributeUniqueId(aliasAttribute);
            this.aliasJSON.put("USER_ID_MODIFIED_FROM", (Object)savedUniqueId);
            Event event = new Event(MoEHelperUtils.getDatapointJSON("EVENT_ACTION_USER_ATTRIBUTE", this.aliasJSON));
            MoEDispatcher.getInstance(this.mContext).writeDataPointToStorage(event);
            Logger.v("SetAliasTask completed alias task");
        }
        catch (Exception e) {
            Logger.v("SetAliasTask execute() ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "SET_ALIAS";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

