/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.Toast;
import com.moengage.core.Logger;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONObject;

public final class MoEHelperUtils {
    static final int[] MONTH_NUMBERS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int BASELINE_SCREEN_DPI = 160;
    private static final String EVENT_ACTION = "EVENT_ACTION";
    public static final String EVENT_ATTRS = "EVENT_ATTRS";
    public static final String EVENT_ATTRS_CUST = "EVENT_ATTRS_CUST";
    private static final String EVENT_G_TIME = "EVENT_G_TIME";
    private static final String EVENT_L_TIME = "EVENT_L_TIME";
    private static final String EXTRA_KEY_FROM_INBOX = "from";
    private static final String EXTRA_VALUE_FROM_INBOX = "inbox";

    private MoEHelperUtils() {
    }

    public static Bundle convertJSONObjecttoBundle(JSONObject jsonObject) {
        Bundle newBundle = null;
        try {
            Iterator keys = jsonObject.keys();
            newBundle = new Bundle();
            while (keys.hasNext()) {
                String nextKey = (String)keys.next();
                String nextValue = jsonObject.getString(nextKey);
                if (nextValue instanceof Integer) {
                    newBundle.putInt(nextKey, ((Integer)((Object)nextValue)).intValue());
                    continue;
                }
                if (nextValue instanceof Boolean) {
                    newBundle.putBoolean(nextKey, ((Boolean)((Object)nextValue)).booleanValue());
                    continue;
                }
                if (nextValue instanceof String) {
                    newBundle.putString(nextKey, nextValue);
                    continue;
                }
                if (nextValue instanceof Byte) {
                    newBundle.putByte(nextKey, ((Byte)((Object)nextValue)).byteValue());
                    continue;
                }
                if (nextValue instanceof Character) {
                    newBundle.putChar(nextKey, ((Character)((Object)nextValue)).charValue());
                    continue;
                }
                if (nextValue instanceof Double) {
                    newBundle.putDouble(nextKey, ((Double)((Object)nextValue)).doubleValue());
                    continue;
                }
                if (nextValue instanceof Float) {
                    newBundle.putFloat(nextKey, ((Float)((Object)nextValue)).floatValue());
                    continue;
                }
                if (nextValue instanceof Long) {
                    newBundle.putLong(nextKey, ((Long)((Object)nextValue)).longValue());
                    continue;
                }
                if (!(nextValue instanceof Short)) continue;
                newBundle.putShort(nextKey, ((Short)((Object)nextValue)).shortValue());
            }
        }
        catch (Exception e) {
            return newBundle;
        }
        return newBundle;
    }

    public static void copyCouponCodeToClipboard(Context mContext, String couponcode) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 11) {
            MoEHelperUtils.copytoClipboardHoneyLess(mContext, couponcode);
        } else {
            MoEHelperUtils.copytoClipboardHoney(mContext, couponcode);
        }
        MoEHelperUtils.showToast("Coupon code copied to clipboard", mContext);
    }

    public static void copyCouponCodeToClipboard(Context mContext, String couponcode, String message) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 11) {
            MoEHelperUtils.copytoClipboardHoneyLess(mContext, couponcode);
        } else {
            MoEHelperUtils.copytoClipboardHoney(mContext, couponcode);
        }
        MoEHelperUtils.showToast(message, mContext);
    }

    public static void showToast(String message, Context mContext) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            Toast.makeText((Context)mContext, (CharSequence)message, (int)0).show();
        }
    }

    @TargetApi(value=11)
    private static void copytoClipboardHoney(Context mContext, String coupon_code) {
        ClipboardManager clipboard = (ClipboardManager)mContext.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"coupon code", (CharSequence)coupon_code);
        clipboard.setPrimaryClip(clip);
    }

    private static void copytoClipboardHoneyLess(Context mContext, String coupon_code) {
        android.text.ClipboardManager clipboard = (android.text.ClipboardManager)mContext.getSystemService("clipboard");
        clipboard.setText((CharSequence)coupon_code);
    }

    public static void dumpIntentExtras(@NonNull Bundle extras) {
        if (extras == null) {
            return;
        }
        Set ketSet = extras.keySet();
        if (null == ketSet || ketSet.isEmpty()) {
            return;
        }
        Logger.v("------Start of bundle extras------");
        for (String key : ketSet) {
            Object obj = extras.get(key);
            if (null == obj) continue;
            Logger.v("[ " + key + " = " + obj.toString() + " ]");
        }
        Logger.v("-------End of bundle extras-------");
    }

    public static void dumpIntentExtras(Intent intent) {
        if (null != intent) {
            MoEHelperUtils.dumpIntentExtras(intent.getExtras());
        }
    }

    public static boolean isChangingConfiguration(Activity activity) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk <= 11) {
            return false;
        }
        return MoEHelperUtils.detectConfigChange(activity);
    }

    @TargetApi(value=11)
    private static boolean detectConfigChange(Activity activity) {
        if (null == activity) {
            return false;
        }
        return activity.isChangingConfigurations();
    }

    public static Intent getLauncherActivityIntent(Context context) {
        PackageManager pm = context.getPackageManager();
        return pm.getLaunchIntentForPackage(context.getPackageName());
    }

    public static Bitmap downloadImageBitmap(String imageUrl) {
        if (imageUrl == null || imageUrl.length() == 0) {
            Logger.e("Null or empty Url string passed to image bitmap download. Not attempting download.");
            return null;
        }
        Bitmap bitmap = null;
        try {
            InputStream inputStream = new URL(imageUrl).openStream();
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (OutOfMemoryError e) {
            Logger.f(String.format("Out of Memory Error in image bitmap download for Url: %s.", imageUrl), e);
        }
        catch (UnknownHostException e) {
            Logger.f(String.format("Unknown Host Exception in image bitmap download for Url: %s. Device may be offline.", imageUrl), e);
        }
        catch (MalformedURLException e) {
            Logger.f(String.format("Malformed URL Exception in image bitmap download for Url: %s. Image Url may be corrupted.", imageUrl), e);
        }
        catch (Exception e) {
            Logger.f(String.format("Exception in image bitmap download for Url: %s", imageUrl), e);
        }
        return bitmap;
    }

    public static String getDate() {
        Calendar c = Calendar.getInstance();
        int hours = c.get(11);
        int mins = c.get(12);
        int secs = c.get(13);
        int day = c.get(5);
        int month = MONTH_NUMBERS[c.get(2)];
        int year = c.get(1);
        StringBuilder dateString = new StringBuilder().append(day).append(":").append(month).append(":").append(year).append(":").append(hours).append(":").append(mins).append(":").append(secs);
        return dateString.toString();
    }

    public static int getPxFromDp(int dpi, int dp) {
        return dpi * dp / 160;
    }

    public static boolean isValidResourceId(Context appContext, int resourceId) {
        try {
            appContext.getResources().getResourceName(resourceId);
            return true;
        }
        catch (Resources.NotFoundException notFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFromInbox(Bundle extras) {
        if (null == extras) {
            return false;
        }
        return extras.containsKey(EXTRA_KEY_FROM_INBOX) && EXTRA_VALUE_FROM_INBOX.equals(extras.getString(EXTRA_KEY_FROM_INBOX));
    }

    public static JSONObject getDatapointJSON(JSONObject generalAttrs, JSONObject customAttrs) {
        try {
            JSONObject result = new JSONObject();
            boolean nothing = true;
            if (null != generalAttrs && generalAttrs.length() != 0) {
                result.put(EVENT_ATTRS, (Object)generalAttrs.toString());
                nothing = false;
            }
            if (null != customAttrs && customAttrs.length() != 0) {
                result.put(EVENT_ATTRS_CUST, (Object)customAttrs.toString());
                nothing = false;
            }
            if (nothing) {
                result.put(EVENT_ATTRS, (Object)new JSONObject().toString());
            }
            result.put(EVENT_G_TIME, (Object)Long.toString(System.currentTimeMillis()));
            result.put(EVENT_L_TIME, (Object)MoEHelperUtils.getDate());
            return result;
        }
        catch (Exception e) {
            Logger.f("MoEHelperUtils:getDatapointJSON ", e);
            return null;
        }
    }

    public static JSONObject getDatapointJSON(String action, JSONObject actionAttrs) {
        if (actionAttrs.has(EVENT_G_TIME) && actionAttrs.has(EVENT_L_TIME)) {
            try {
                actionAttrs.put(EVENT_ACTION, (Object)action);
            }
            catch (Exception e) {
                Logger.f("MoEHelperUtils: getDatapointJSON ", e);
            }
            return actionAttrs;
        }
        return MoEHelperUtils.getDatapointJSON(action, actionAttrs, Long.toString(System.currentTimeMillis()), MoEHelperUtils.getDate());
    }

    public static JSONObject getDatapointJSON(String action, JSONObject actionAttrs, String gtime, String ltime) {
        return MoEHelperUtils.getDatapointJSON(action, actionAttrs, null, gtime, ltime);
    }

    public static JSONObject getDatapointJSON(String action, JSONObject generalAttrs, JSONObject customAttrs, String gtime, String ltime) {
        JSONObject jsonInteraction = new JSONObject();
        try {
            jsonInteraction.put(EVENT_ACTION, (Object)action);
            if (null != generalAttrs) {
                jsonInteraction.put(EVENT_ATTRS, (Object)generalAttrs.toString());
            }
            if (null != customAttrs && customAttrs.length() != 0) {
                jsonInteraction.put(EVENT_ATTRS_CUST, (Object)customAttrs.toString());
            }
            jsonInteraction.put(EVENT_G_TIME, (Object)gtime);
            jsonInteraction.put(EVENT_L_TIME, (Object)ltime);
            return jsonInteraction;
        }
        catch (Exception e) {
            Logger.f("MoEHelperUtils:getDatapointJSON", e);
            return null;
        }
    }

    public static String getActionFromEvent(String actionDetails) {
        try {
            JSONObject actionObj = new JSONObject(actionDetails);
            return actionObj.getString(EVENT_ACTION);
        }
        catch (Exception e) {
            Logger.f("MoEHelperUtils:getActionFromEvent", e);
            return null;
        }
    }

    public static boolean hasPermission(Context appContext, String permission) {
        try {
            if (null == appContext || TextUtils.isEmpty((CharSequence)permission)) {
                return false;
            }
            PackageManager pm = appContext.getPackageManager();
            return pm.checkPermission(permission, appContext.getPackageName()) == 0;
        }
        catch (RuntimeException ignored) {
            Logger.f("MoEHelperUtils: hasPermission ", ignored);
        }
        catch (Exception ignored) {
            Logger.f("MoEHelperUtils: hasPermission ", ignored);
        }
        return false;
    }
}

