/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEActivityLifeCycleCallBacks;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.GeoLocation;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEEventManager;
import com.moengage.core.listeners.OnAppBackgroundListener;
import com.moengage.core.listeners.OnLogoutCompleteListener;
import com.moengage.core.userattributes.MoEAttributeManager;
import com.moengage.inapp.InAppController;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class MoEHelper {
    private MoEDispatcher mDispatcher = null;
    private String BUNDLE_EXTRA_RESTORING = "EXTRA_RESTORING";
    private boolean isActivityBeingRestored = false;
    private Context mContext;
    private static int activityCounter = 0;
    private static String TAG = "MoEHelper";
    private MoEAttributeManager attributeManager = null;
    private boolean mStarted = false;
    private boolean mResumed = false;
    private static MoEHelper _INSTANCE = null;
    private static boolean isAutoIntegration = false;
    private MoEActivityLifeCycleCallBacks mLifeCycleCallBacks;
    private long flushInterval = -1L;
    private boolean isPeriodicSyncEnabled = true;
    private OnAppBackgroundListener onAppBackgroundListener;

    public static int getActivityCounter() {
        return activityCounter;
    }

    private static synchronized void incrementCounter() {
        ++activityCounter;
    }

    private static synchronized void decrementCounter() {
        --activityCounter;
    }

    public static boolean isAppInForeground() {
        return activityCounter > 0;
    }

    @Deprecated
    public MoEHelper(Context con) {
        this.mContext = con.getApplicationContext();
        if (null == this.mDispatcher) {
            this.mDispatcher = this.getDelegate();
        }
        this.attributeManager = this.getAttributeManager();
        _INSTANCE = this;
    }

    public static synchronized MoEHelper getInstance(Context con) {
        if (null == _INSTANCE) {
            _INSTANCE = new MoEHelper(con);
        }
        return _INSTANCE;
    }

    @Deprecated
    public void initialize(String senderId, String appId) {
        this.mDispatcher.initialize(senderId, appId);
    }

    public void onNewIntent(Activity activity, Intent intent) {
        if (!this.isActivityBeingRestored) {
            this.mDispatcher.onStart(activity, intent);
        }
        InAppController.getInstance().registerInAppManager(activity);
    }

    @Deprecated
    public void onStart(@NonNull Activity activity) {
        if (isAutoIntegration) {
            return;
        }
        this.onStartInternal(activity);
    }

    void onStartInternal(@NonNull Activity activity) {
        if (MoEHelper.getActivityCounter() == 0) {
            this.mDispatcher.onAppOpen();
        }
        MoEHelper.incrementCounter();
        this.mStarted = true;
        this.mContext = activity.getApplicationContext();
        this.onNewIntent(activity, null);
    }

    @Deprecated
    public void onStop(@NonNull Activity activity) {
        if (isAutoIntegration) {
            return;
        }
        this.onStopInternal(activity);
    }

    void onStopInternal(@NonNull Activity activity) {
        Logger.v("Activity onStop called for " + activity.toString());
        boolean configChange = MoEHelperUtils.isChangingConfiguration(activity);
        MoEHelper.decrementCounter();
        InAppController.getInstance().unregisterInAppManager(activity);
        this.mDispatcher.onStop(activity, configChange);
        String activityName = activity.getClass().getName();
        if (!this.mStarted) {
            Logger.e("MoEHelper: onStart callback not called: " + activityName);
        }
        if (!this.mResumed) {
            Logger.e("MoEHelper: onResume callback not called: " + activityName);
        }
    }

    public void onResume(@NonNull Activity activity) {
        if (isAutoIntegration) {
            return;
        }
        this.onResumeInternal(activity);
    }

    void onResumeInternal(Activity activity) {
        if (null == this.mContext) {
            this.mContext = activity.getApplicationContext();
        }
        Logger.v("Activity onResume called for " + activity.toString());
        this.mResumed = true;
        this.mDispatcher.onResume(activity, this.isActivityBeingRestored);
        this.isActivityBeingRestored = false;
    }

    public void onFragmentStart(Activity activity, String fragmentName) {
        this.mDispatcher.onFragmentStart(activity, fragmentName);
    }

    public void onFragmentStop(Activity activity, String fragmentName) {
    }

    public void onSaveInstanceState(Bundle outState) {
        Logger.v("MoEHelper:onSaveInstanceState-- saving state");
        if (null == outState) {
            return;
        }
        outState.putBoolean(this.BUNDLE_EXTRA_RESTORING, true);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        Logger.v("MoEHelper:onRestoreInstanceState-- restoring state");
        if (null == savedInstanceState) {
            return;
        }
        if (savedInstanceState.containsKey(this.BUNDLE_EXTRA_RESTORING)) {
            this.isActivityBeingRestored = true;
            savedInstanceState.remove(this.BUNDLE_EXTRA_RESTORING);
        }
    }

    public MoEHelper trackEvent(@NonNull String action, JSONObject attrs) {
        if (TextUtils.isEmpty((CharSequence)action)) {
            return this;
        }
        MoEEventManager.getInstance(this.mContext).trackEvent(action.trim(), attrs);
        return this;
    }

    public MoEHelper trackEvent(@NonNull String action, @NonNull HashMap<String, String> attrs) {
        if (TextUtils.isEmpty((CharSequence)action)) {
            return this;
        }
        Set<String> keySet = attrs.keySet();
        if (keySet.isEmpty()) {
            return this;
        }
        JSONObject newAttrs = new JSONObject();
        for (String key : keySet) {
            try {
                newAttrs.put(key, (Object)attrs.get(key));
            }
            catch (Exception e) {
                Logger.f("MoEHelper:trackEvent", e);
            }
        }
        this.trackEvent(action.trim(), newAttrs);
        return this;
    }

    public MoEHelper trackEvent(@NonNull String action, @NonNull Map<String, String> attrs) {
        Set<String> keySet = attrs.keySet();
        if (keySet.isEmpty()) {
            return this;
        }
        JSONObject newAttrs = new JSONObject();
        for (String key : keySet) {
            try {
                newAttrs.put(key, (Object)attrs.get(key));
            }
            catch (Exception e) {
                Logger.f("MoEHelper:trackEvent", e);
            }
        }
        this.trackEvent(action, newAttrs);
        return this;
    }

    public MoEHelper trackEvent(@NonNull String action) {
        if (TextUtils.isEmpty((CharSequence)action)) {
            return this;
        }
        MoEEventManager.getInstance(this.mContext).trackEvent(action.trim(), new JSONObject());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, @NonNull String attributeValue) {
        if (userAttribute == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        try {
            if (attributeValue == null) {
                attributeValue = "";
            } else if ("USER_ATTRIBUTE_USER_BDAY".equals(userAttribute)) {
                attributeValue = URLEncoder.encode(attributeValue, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e1) {
            Logger.f("MoEHelper:setUserAttribute", e1);
        }
        catch (Exception e) {
            Logger.f("MoEHelper:setUserAttribute", e);
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), (Object)attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.f("MoEHelper:setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, int attributeValue) {
        if (userAttribute == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.f("MoEHelper:setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, boolean attributeValue) {
        if (userAttribute == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.f("MoEHelper:setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, double attributeValue) {
        if (userAttribute == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.f("MoEHelper:setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, float attributeValue) {
        if (userAttribute == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), (double)attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.f("MoEHelper:setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, long attributeValue) {
        if (userAttribute == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.f("MoEHelper:setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttributeEpochTime(@NonNull String userAttribute, long attributeValue) {
        if (userAttribute == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDateEpoch(userAttribute, attributeValue).build());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull HashMap<String, Object> attributeMap) {
        if (attributeMap.isEmpty()) {
            Logger.e("MoEHelper:User attribute map cannot be null or empty");
            return this;
        }
        Set<String> keySet = attributeMap.keySet();
        if (keySet.isEmpty()) {
            return this;
        }
        for (String key : keySet) {
            try {
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                Object attrValue = attributeMap.get(key);
                if (attrValue instanceof Date) {
                    this.setUserAttribute(key.trim(), (Date)attrValue);
                    continue;
                }
                if (attrValue instanceof GeoLocation) {
                    this.setUserAttribute(key.trim(), (GeoLocation)attrValue);
                    continue;
                }
                if (attrValue instanceof Location) {
                    this.setUserAttribute(key.trim(), (Location)attrValue);
                    continue;
                }
                JSONObject userJson = new JSONObject();
                userJson.put(key.trim(), attrValue);
                this.attributeManager.setUserAttribute(userJson);
            }
            catch (Exception e) {
                Logger.f("MoEHelper:setUserAttribute", e);
            }
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull Map<String, Object> attributeMap) {
        if (attributeMap.isEmpty()) {
            Logger.e("MoEHelper:User attribute map cannot be null or empty");
            return this;
        }
        Set<String> keySet = attributeMap.keySet();
        if (keySet.isEmpty()) {
            return this;
        }
        for (String key : keySet) {
            try {
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                Object attrValue = attributeMap.get(key);
                if (attrValue instanceof Date) {
                    this.setUserAttribute(key.trim(), (Date)attrValue);
                    continue;
                }
                if (attrValue instanceof GeoLocation) {
                    this.setUserAttribute(key.trim(), (GeoLocation)attrValue);
                    continue;
                }
                if (attrValue instanceof Location) {
                    this.setUserAttribute(key.trim(), (Location)attrValue);
                    continue;
                }
                JSONObject userJson = new JSONObject();
                userJson.put(key.trim(), attrValue);
                this.attributeManager.setUserAttribute(userJson);
            }
            catch (Exception e) {
                Logger.f("MoEHelper:setUserAttribute", e);
            }
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String name, @NonNull Date value) {
        if (name == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate(name, value).build());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String name, @NonNull String date, String dateFormat) {
        if (name == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate(name, date, dateFormat).build());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String name, @NonNull Location location) {
        if (name == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrLocation(name, location).build());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String name, @NonNull GeoLocation location) {
        if (name == null) {
            Logger.e("MoEHelper:User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrLocation(name, location).build());
        return this;
    }

    public void setUserLocation(double lat, double lng) {
        this.setUserAttribute("last_known_location", new GeoLocation(lat, lng));
    }

    @WorkerThread
    public int getUnreadMessagesCount() {
        return this.mDispatcher.getUnreadMessageCount();
    }

    public void showInAppIfAny(boolean force) {
        this.mDispatcher.checkForInAppMessages(force);
    }

    public void setExistingUser(boolean existingUser) {
        this.mDispatcher.setExistingUser(existingUser, this.mContext);
    }

    @Nullable
    @WorkerThread
    public static Cursor getAllMessages(Context context) {
        return MoEDispatcher.getInstance(context).getAllMessages();
    }

    @WorkerThread
    public static void setMessageClicked(Context context, long id) {
        MoEDispatcher.getInstance(context).setInboxMessageClicked(id);
    }

    public void logoutUser() {
        if (null == this.mContext) {
            return;
        }
        this.mDispatcher.logoutUser(false);
    }

    public void syncInteractionDataNow() {
        this.mDispatcher.sendInteractionData();
    }

    public void setNotificationPreference(String dontSendStart, String dontSendEnd, String timezone, String format) {
        try {
            JSONObject obj = new JSONObject();
            obj.put("USER_ATTRIBUTE_DND_START_TIME", (Object)dontSendStart);
            obj.put("USER_ATTRIBUTE_DND_END_TIME", (Object)dontSendEnd);
            obj.put("MOE_TIME_TIMEZONE", (Object)timezone);
            obj.put("MOE_TIME_FORMAT", (Object)format);
            JSONObject userAttrObj = new JSONObject();
            userAttrObj.put("USER_ATTRIBUTE_NOTIFICATION_PREF", (Object)obj.toString());
            this.attributeManager.setUserAttribute(userAttrObj);
        }
        catch (Exception e) {
            Logger.f("MoEHelper: setNotificationPreference", e);
        }
    }

    @Deprecated
    public void optOutOfAdIdCollection(Context context, boolean optOut) {
        ConfigurationProvider.getInstance(context).optOutOfAdIdCollection(optOut);
    }

    @Deprecated
    public void optOutOfLocationTracking(boolean optOut) {
        ConfigurationProvider.getInstance(this.mContext).optOutOfTrackLocation(optOut);
    }

    @Deprecated
    public void optOutOfGeoFences(boolean optOut) {
        ConfigurationProvider.getInstance(this.mContext).optOutOfSetGeoFence(optOut);
    }

    public void trackNotificationClickedByTime(long gtime) {
        this.mDispatcher.trackNotificationClicked(gtime);
    }

    public void playNotificationSound(boolean state) {
        ConfigurationProvider.getInstance(this.mContext).saveNotificationSoundState(state);
    }

    @Deprecated
    public void autoIntegrate(Application application) {
        if (Build.VERSION.SDK_INT >= 14) {
            Logger.d("MoEHelper: Auto integration is enabled");
            if (this.mLifeCycleCallBacks == null) {
                this.mLifeCycleCallBacks = new MoEActivityLifeCycleCallBacks();
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mLifeCycleCallBacks);
                isAutoIntegration = true;
            }
        }
    }

    public void unregisterLifecycleCallbacks(@NonNull Application application) {
        if (Build.VERSION.SDK_INT >= 14) {
            Logger.v("MoEHelper unregisterLifecycleCallbacks() : will try to unregister lifecycle callbacks");
            if (this.mLifeCycleCallBacks != null && application != null) {
                Logger.v(TAG + " unregisterLifecycleCallbacks() : un-registering for lifecycle callbacks");
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mLifeCycleCallBacks);
                isAutoIntegration = false;
            } else {
                Logger.v(TAG + " unregisterLifecycleCallbacks() : either lifecycle callbacks or application class instance is null cannot unregister.");
            }
        }
    }

    public MoEDispatcher getDelegate() {
        if (null == this.mDispatcher) {
            this.mDispatcher = MoEDispatcher.getInstance(this.mContext);
        }
        return this.mDispatcher;
    }

    public void setEmail(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_EMAIL", value);
    }

    public void setFullName(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_NAME", value);
    }

    public void setGender(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_GENDER", value);
    }

    public void setFirstName(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_FIRST_NAME", value);
    }

    public void setLastName(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_LAST_NAME", value);
    }

    @Deprecated
    public void setBirthDate(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_BDAY", value);
    }

    public void setBirthDate(@NonNull Date birthDate) {
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate("USER_ATTRIBUTE_USER_BDAY", birthDate).build());
    }

    public void setUniqueId(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setUniqueId(int value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setUniqueId(long value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setUniqueId(float value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setUniqueId(double value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setNumber(String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.setUserAttribute("USER_ATTRIBUTE_USER_MOBILE", value);
        }
    }

    @Deprecated
    public void setLogLevel(int logLevel) {
        Logger.setLogLevel(logLevel);
    }

    @Deprecated
    public void setLogStatus(boolean status) {
        Logger.setLogStatus(status);
    }

    @Deprecated
    public void optOutOfAndroidIdCollection(@NonNull Context context, boolean optOut) {
        ConfigurationProvider.getInstance(context).optOutOfAndroidIdCollection(optOut);
    }

    @Deprecated
    public void optOutOfOperatorNameCollection(@NonNull Context context, boolean optOut) {
        ConfigurationProvider.getInstance(context).optOutOfOperatorNameCollection(optOut);
    }

    @Deprecated
    public void optOutOfIMEICollection(@NonNull Context context, boolean optOut) {
    }

    @Deprecated
    public void optOutOfDeviceAttributeCollection(@NonNull Context context, boolean optOut) {
        ConfigurationProvider.getInstance(context).optOutOfDeviceAttributesCollection(optOut);
    }

    public void trackDeviceLocale() {
        this.mDispatcher.trackDeviceLocale();
    }

    public void setAlias(double currentId) {
        try {
            JSONObject userJSON = new JSONObject();
            userJSON.put("USER_ATTRIBUTE_UNIQUE_ID", currentId);
            this.mDispatcher.setAlias(userJSON);
        }
        catch (Exception e) {
            Logger.f("MoEHelper: setAlias() ", e);
        }
    }

    public void setAlias(String currentId) {
        try {
            if (TextUtils.isEmpty((CharSequence)currentId)) {
                Logger.e("Updated id cannot be null");
                return;
            }
            JSONObject userJSON = new JSONObject();
            userJSON.put("USER_ATTRIBUTE_UNIQUE_ID", (Object)currentId.trim());
            this.mDispatcher.setAlias(userJSON);
        }
        catch (Exception e) {
            Logger.f("MoEHelper: setAlias() ", e);
        }
    }

    public void setAlias(long currentId) {
        try {
            JSONObject userJSON = new JSONObject();
            userJSON.put("USER_ATTRIBUTE_UNIQUE_ID", currentId);
            this.mDispatcher.setAlias(userJSON);
        }
        catch (Exception e) {
            Logger.f("MoEHelper: setAlias() ", e);
        }
    }

    public void setAlias(int currentId) {
        try {
            JSONObject userJSON = new JSONObject();
            userJSON.put("USER_ATTRIBUTE_UNIQUE_ID", currentId);
            this.mDispatcher.setAlias(userJSON);
        }
        catch (Exception e) {
            Logger.f("MoEHelper: setAlias() ", e);
        }
    }

    public void trackUserPushPreference(boolean pushPreference) {
        this.setUserAttribute("USER_PUSH_PREFERENCE", pushPreference);
    }

    @Deprecated
    public void redirectDataToRegion(int regionConstant) {
        ConfigurationProvider.getInstance(this.mContext).setDataRegion(regionConstant);
    }

    @Deprecated
    public void setFlushInterval(long flushInterval) {
        if (flushInterval < ConfigurationProvider.getInstance(this.mContext).getPeriodicFlushTime()) {
            Logger.e("MoEHelper:setFlushInterval() cannot set interval less than threshold. Threshold value: " + ConfigurationProvider.getInstance(this.mContext).getPeriodicFlushTime());
            return;
        }
        this.flushInterval = flushInterval;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    @Deprecated
    public void setPeriodicFlushState(boolean periodicFlushState) {
        this.isPeriodicSyncEnabled = periodicFlushState;
    }

    public boolean getPeriodicSyncState() {
        return this.isPeriodicSyncEnabled;
    }

    public void fetchDeviceTriggersIfRequired() {
        MoEDTManager.getInstance().syncDeviceTriggersIfRequired(this.mContext);
    }

    public void setOnLogoutCompleteListener(OnLogoutCompleteListener listener) {
        this.mDispatcher.setOnLogoutCompleteListener(listener);
    }

    public void removeLogoutCompleteListener() {
        this.mDispatcher.removeOnLogoutCompleteListener();
    }

    public MoEHelper setUserAttributeISODate(@NonNull String attributeName, @NonNull String attributeValue) {
        this.mDispatcher.setCustomUserAttribute(new PayloadBuilder().putAttrISO8601Date(attributeName, attributeValue).build());
        return this;
    }

    public void registerAppBackgroundListener(OnAppBackgroundListener listener) {
        Logger.v(TAG + " registerAppBackgroundListener() : Registering OnAppBackgroundListener");
        this.onAppBackgroundListener = listener;
    }

    public void unregisterAppBackgroundListener() {
        Logger.v(TAG + " unregisterAppBackgroundListener() : Unregistering OnAppBackgroundListener");
        this.onAppBackgroundListener = null;
    }

    @Nullable
    public OnAppBackgroundListener getOnAppBackgroundListener() {
        return this.onAppBackgroundListener;
    }

    public MoEAttributeManager getAttributeManager() {
        return this.getDelegate().getAttributeManager();
    }
}

