package com.moengage.core.rest;

import android.net.Uri;
import com.moengage.core.rest.RequestBuilder.RequestType;
import java.util.Map;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class Request {

  private RequestType requestType;
  private Map<String, String> headersMap;
  private JSONObject requestBody;
  private String contentType;
  private Uri uri;

  Request(Uri uri, RequestType requestType, Map<String, String> headersMap, JSONObject requestBody,
      String contentType){
    this.uri = uri;
    this.requestType = requestType;
    this.headersMap = headersMap;
    this.requestBody = requestBody;
    this.contentType = contentType;
  }

  public Uri getUrl() {
    return uri;
  }

  RequestType getRequestType() {
    return requestType;
  }

  Map<String, String> getHeadersMap() {
    return headersMap;
  }

  JSONObject getRequestBody() {
    return requestBody;
  }

  String getContentType() {
    return contentType;
  }

}
