package com.moengage.core.listeners;

/**
 * Callback listener to get notified when logout process is complete.
 * Usage: <br>
 * Setting listener
 * <pre>
 *   <code>
 *     MoEHelper.getInstance(mContext).setOnLogoutCompleteListener(listener);
 *   </code>
 * </pre>
 * Remove Listener
 * <pre>
 *   <code>
 *     MoEHelper.getInstance(mContext).removeLogoutCompleteListener()
 *   </code>
 * </pre>
 *
 * @author Umang Chamaria
 * @since 9.1.00
 */
public interface OnLogoutCompleteListener {
  /**
   * Logout complete callback.
   */
  void logoutComplete();
}
