/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.core;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moe.pushlibrary.utils.ReflectionUtils;
import com.moengage.core.model.DataTypes;
import com.moengage.core.model.MoEAttribute;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import static android.Manifest.permission.ACCESS_WIFI_STATE;
import static android.Manifest.permission.READ_PHONE_STATE;
import static android.content.Context.CONNECTIVITY_SERVICE;
import static android.content.Context.TELEPHONY_SERVICE;
import static android.content.pm.PackageManager.FEATURE_TELEPHONY;
import static android.provider.Settings.Secure.ANDROID_ID;
import static android.provider.Settings.Secure.getString;

/**
 * @author MoEngage (abhishek@moenegage.com)
 * @version 5.0
 * @since 1.0
 */
public final class MoEUtils {

  private static final String TAG = "MoEUtils";

  @Nullable static String getOperatorName(Context context) {
    try {
      if (!ConfigurationProvider.getInstance(context).isOperatorNameCollectionProhibited()) {
        if (MoEHelperUtils.hasPermission(context, READ_PHONE_STATE) && hasFeature(context,
            FEATURE_TELEPHONY)) {
          TelephonyManager telephonyManager =
              ((TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE));
          return telephonyManager.getSimOperatorName();
        }
      }
    } catch (Exception ignored) {
    }
    return null;
  }

  public static String convertBundletoJSONString(Bundle newBundle) {
    Set<String> keys = newBundle.keySet();
    JSONObject jsonObject = new JSONObject();
    for (String key : keys) {
      try {
        jsonObject.put(key, newBundle.get(key));
      } catch (Exception e) {
        Logger.f("MoEUtils:convertBundletoJSONString", e);
      }
    }
    return jsonObject.toString();
  }

  public static void showNormalDialogWithOk(String message, Context context) {
    if (null == context) return;
    AlertDialog.Builder builder = new AlertDialog.Builder(context);
    builder.setMessage(message).setPositiveButton("OK", new DialogInterface.OnClickListener() {
      public void onClick(DialogInterface dialog, int id) {
      }
    });
    AlertDialog dialog = builder.create();
    dialog.show();
  }

  public static void showCouponDialog(String message, final String couponcode,
      final Context context) {
    if (null == context) return;
    AlertDialog.Builder builder = new AlertDialog.Builder(context);
    builder.setMessage(message)
        .setPositiveButton("Copy Code", new DialogInterface.OnClickListener() {
          public void onClick(DialogInterface dialog, int id) {
            MoEHelperUtils.copyCouponCodeToClipboard(context, couponcode);

            JSONObject newJson = new JSONObject();
            try {
              newJson.put("coupon_code", couponcode);
            } catch (Exception e) {
              Logger.f("showCouponDialog", e);
            }

            MoEEventManager.getInstance(context)
                .trackEvent(MoEConstants.EVENT_ACTION_COUPON_CODE_COPY, newJson);
          }
        });
    AlertDialog dialog = builder.create();
    dialog.show();
  }

  /*
   * Checks if user has enabled "Opt out of interest-based ads"
   *
   * @param context An instance of the application {@link Context}
   * @return return {@link AdvertisingIdClient.AdInfo}
   */
  @Nullable public static AdvertisingIdClient.AdInfo getAdvertisementInfo(Context context) {
    try {
      try {
        return AdvertisingIdClient.getAdvertisingIdInfo(context);
      } catch (Exception e) {
        Object adInfo = ReflectionUtils.invokeStatic(
            "com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo",
            new Class[] { Context.class }, new Object[] { context });
        if (null != adInfo) {
          String advertisingId =
              (String) ReflectionUtils.invokeInstance(adInfo, "getId", null, null);
          boolean isLimit =
              ((Boolean) ReflectionUtils.invokeInstance(adInfo, "isLimitAdTrackingEnabled", null,
                  null)).booleanValue();
          return new AdvertisingIdClient.AdInfo(
              TextUtils.isEmpty(advertisingId) ? null : advertisingId, isLimit ? 1 : 0);
        } else {
          Logger.v(
              "It is advised that you add ----> com.google.android.gms:play-services-ads:7.5.0");
        }
      }
    } catch (Exception e) {
      Logger.f("MoEUtils:getAdvertisementInfo", e);
    }
    return null;
  }

  /**
   * Set the current exponential back off counter whihc needs to be used for
   * the device add call or the GCM registration
   *
   * @param context An instance of the Application Context
   * @param delayInSeconds The exponential backoff counter in seconds
   */
  public static void saveCurrentExponentialCounter(Context context, int delayInSeconds) {
    if (null == context) return;
    SharedPreferences sp = getSharedPrefs(context);
    sp.edit().putInt(MoEConstants.EXPONENTIAL_CONSTANT_MOE, delayInSeconds).apply();
  }

  /**
   * Get the current exponential backoff counter which needs to be used for
   * GCM registration or device add call
   *
   * @param context AN instance of the application context
   * @return the exponential back off counter in seconds
   */
  public static int getCurrentExponentialCounter(Context context) {
    if (null == context) return 1;
    SharedPreferences sp = getSharedPrefs(context);
    return sp.getInt(MoEConstants.EXPONENTIAL_CONSTANT_MOE, 1);
  }

  /**
   * Set install registered state as true
   *
   * @param context Application Context
   */
  public static void setInstallRegistered(Context context) {
    if (null == context) return;
    SharedPreferences sp = getSharedPrefs(context);
    sp.edit().putBoolean(MoEConstants.PREF_KEY_INSTALL_LOGGED, true).apply();
  }

  /**
   * Check whether install has been registered or not
   *
   * @param context Application Context
   * @return true if the install has been registered and false otherwise
   */
  public static boolean isInstallRegistered(Context context) {
    if (null == context) return false;
    SharedPreferences sp = getSharedPrefs(context);
    return sp.getBoolean(MoEConstants.PREF_KEY_INSTALL_LOGGED, false);
  }

  private static SharedPreferences getSharedPrefs(Context context) {
    if (null == context) return null;
    return context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE);
  }

  private static final String PREF_NAME = "pref_moe";

  public static boolean isRegistrationScheduled(Context context) {
    SharedPreferences sp = getSharedPrefs(context);
    return sp.getBoolean(MoEConstants.PREF_KEY_DEVICE_ADD_SCHEDULED, false);
  }

  public static void setRegistrationScheduled(Context context, boolean scheduled) {
    SharedPreferences sp = getSharedPrefs(context);
    sp.edit().putBoolean(MoEConstants.PREF_KEY_DEVICE_ADD_SCHEDULED, scheduled).apply();
  }

  /* Returns true if the application has the given feature. */
  public static boolean hasFeature(Context context, String feature) {
    return context.getPackageManager().hasSystemFeature(feature);
  }

  /* Returns true if the string is null, or empty (once trimmed). */
  public static boolean isNullOrEmpty(CharSequence text) {
    return TextUtils.isEmpty(text) || TextUtils.getTrimmedLength(text) == 0;
  }

  /* Returns true if the collection or has a size 0. */
  public static boolean isNullOrEmpty(Collection collection) {
    return collection == null || collection.size() == 0;
  }

  /*
   * @param map
   * @return Returns true if the map is null or empty, false otherwise.
   * */
  public static boolean isNullOrEmpty(Map map) {
    return map == null || map.size() == 0;
  }

  /*
   * @param context Application Context
   * @return Returns the system service for the given string.
   * */
  @SuppressWarnings("unchecked") public static <T> T getSystemService(Context context,
      String serviceConstant) {
    return (T) context.getSystemService(serviceConstant);
  }

  public static String getAndroidID(Context context) {
    if (!ConfigurationProvider.getInstance(context).isAndroidIdCollectionProhibited()) {
      String androidId = getString(context.getContentResolver(), ANDROID_ID);
      if (!isNullOrEmpty(androidId) && !"9774d56d682e549c".equals(androidId) && !"unknown".equals(
          androidId) && !"000000000000000".equals(androidId)) {
        return androidId;
      }
    }
    return null;
  }

  public static String getNetworkType(Context context) {
    try {
      if (MoEHelperUtils.hasPermission(context, ACCESS_WIFI_STATE)) {
        NetworkInfo wifiInfo =
            ((ConnectivityManager) context.getSystemService(CONNECTIVITY_SERVICE)).getNetworkInfo(
                1);
        if ((null != wifiInfo) && (wifiInfo.isConnectedOrConnecting())) {
          return "wifi";
        }
      }
      if (MoEHelperUtils.hasPermission(context, READ_PHONE_STATE) && hasFeature(context,
          FEATURE_TELEPHONY)) {
        TelephonyManager telephonyManager = getSystemService(context, TELEPHONY_SERVICE);
        int type = telephonyManager.getNetworkType();
        switch (type) {
          case TelephonyManager.NETWORK_TYPE_GPRS:
          case TelephonyManager.NETWORK_TYPE_EDGE:
          case TelephonyManager.NETWORK_TYPE_CDMA:
          case TelephonyManager.NETWORK_TYPE_1xRTT:
          case TelephonyManager.NETWORK_TYPE_IDEN: //api<8 : replace by 11
            return "2G";
          case TelephonyManager.NETWORK_TYPE_UMTS:
          case TelephonyManager.NETWORK_TYPE_EVDO_0:
          case TelephonyManager.NETWORK_TYPE_EVDO_A:
          case TelephonyManager.NETWORK_TYPE_HSDPA:
          case TelephonyManager.NETWORK_TYPE_HSUPA:
          case TelephonyManager.NETWORK_TYPE_HSPA:
          case TelephonyManager.NETWORK_TYPE_EVDO_B: //api<9 : replace by 14
          case TelephonyManager.NETWORK_TYPE_EHRPD:  //api<11 : replace by 12
          case TelephonyManager.NETWORK_TYPE_HSPAP:  //api<13 : replace by 15
            return "3G";
          case TelephonyManager.NETWORK_TYPE_LTE:    //api<11 : replace by 13
            return "4G";
          default:
            return "CouldNotDetermine";
        }
      }
    } catch (Exception e) {
      Logger.f("MoEUtils: getNetworkType", e);
    }
    return null;
  }

  /**
   * Call this for tracking activity see and activity stopped only<br>
   * <b>Note : Don't call from UI thread.</b>
   *
   * @param activityState activity state being tracked
   * @param activityName The name of the activity which is changing view state
   * @param context An instance of the application {@link Context}
   */
  @WorkerThread static void trackActivityStates(String activityState, String activityName,
      Context context) {
    JSONObject activityJson = new JSONObject();
    try {
      activityJson.put(MoEConstants.EVENT_ACTIVITY_NAME, activityName);
      trackEventInternal(activityState, activityJson, context);
    } catch (Exception e) {
      Logger.f("MoEUtils :trackActivityStates", e);
    }
  }

  static void trackEventInternal(String event, JSONObject object, Context context) {
    Event ev = new Event(event, object);
    MoEDAO.getInstance(context).addEvent(ev, context);
  }

  /**
   * Sets a user attribute
   *
   * @param context Application/Activity context
   * @param attr attribute name
   * @param value value for the attribute
   */
  public static void setUserAttributeInternal(Context context, String attr, String value) {
    JSONObject userJson = new JSONObject();
    try {
      userJson.put(attr, value);
      trackEventInternal(MoEConstants.EVENT_ACTION_USER_ATTRIBUTE, userJson, context);
    } catch (Exception e) {
      Logger.f("MoEutils : setUserAttribute", e);
    }
  }

  public static String getAPIRoute(Context context) {
    int region = ConfigurationProvider.getInstance(context).getDataRegion();
    if (region != -999){
      switch(region){
        case MoEHelperConstants.MOE_REGION_EU:
          return MoEConstants.API_V2_EU;
        case MoEHelperConstants.MOE_REGION_INDIA:
          return MoEConstants.API_V2_INDIA;
        case MoEHelperConstants.MOE_REGION_DEFAULT:
          return MoEConstants.API_GENERAL_V2;
        default:
          return MoEConstants.API_GENERAL_V2;
      }
    }
    return MoEConstants.API_GENERAL_V2;
  }

  public static String addDebugIfRequired(Context con, String appId) {
    boolean DEBUG_ENABLED =
        (0 != (con.getApplicationInfo().flags & ApplicationInfo.FLAG_DEBUGGABLE));
    if (DEBUG_ENABLED) {
      appId += "_DEBUG";
    }
    return appId;
  }

  @Nullable public static Bundle convertMapToBundle(Map<String, String> map) {
    if (map == null) return null;
    Bundle bundle = new Bundle();
    try {
      for (Map.Entry<String, String> entry : map.entrySet()) {
        bundle.putString(entry.getKey(), entry.getValue());
      }
    } catch (Exception e) {
      Logger.f("MoEUtils#convertMapToBundle : Exception", e);
    }
    return bundle;
  }

  @Nullable public static Bundle jsonToBundle(JSONObject json) {
    if (json == null) return null;
    try {
      Bundle bundle = new Bundle();
      Iterator iter = json.keys();
      while (iter.hasNext()) {
        String key = (String) iter.next();
        String value = json.getString(key);
        bundle.putString(key, value);
      }
      return bundle;
    } catch (JSONException e) {
      Logger.f("MoEUtils : jsonToBundle", e);
    }
    return null;
  }

  public static void updateTestDeviceState(Context context) {
    long registeredTime =
        ConfigurationProvider.getInstance(context).getVerificationRegistrationTime();
    if ((registeredTime + (3600 * 1000)) < System.currentTimeMillis()) {
      ConfigurationProvider.getInstance(context).setVerificationRegistration(false);
    }
  }

  @Nullable static String convertJSONArrayToString(JSONArray array) {
    if (array == null) return null;
    StringBuilder builder = new StringBuilder();
    try {
      for (int i = 0; i < array.length(); i++) {
        builder.append((String) array.get(i));
        if (i != array.length() - 1) {
          builder.append(MoEConstants.EVENT_SEPARATOR);
        }
      }
      return builder.toString();
    } catch (Exception e) {
      Logger.f("MoEUtils: convertJSONArrayToString", e);
    }
    return null;
  }

  static JSONArray convertStringToJSONArray(String jsonArrayString){
    if (TextUtils.isEmpty(jsonArrayString)) return new JSONArray();
    JSONArray array = new JSONArray();
    String[] arrayElements = jsonArrayString.split(MoEConstants.EVENT_SEPARATOR);
    for (String element:arrayElements) {
      array.put(element);
    }
    return array;
  }

  @Nullable static UserAttribute getUserAttributePoJo(JSONObject userJSON) {
    UserAttribute userAttribute = null;
    try {
      Iterator jsonKeys = userJSON.keys();
      while (jsonKeys.hasNext()) {
        userAttribute = new UserAttribute();
        userAttribute.userAttributeName = (String) jsonKeys.next();
        userAttribute.userAttributeValue = userJSON.getString(userAttribute.userAttributeName);
      }
    } catch (Exception e) {
      Logger.f("MoEDispatcher : getUserAttributePoJo", e);
    }
    return userAttribute;
  }

  static boolean shouldSendUserAttribute(UserAttribute currentUserAttributes,
      UserAttribute savedUserAttributes){
    return currentUserAttributes == null
        || savedUserAttributes == null
        || !savedUserAttributes.equals(currentUserAttributes);
  }

  @Nullable static UserAttribute getSavedUserAttribute(Context context, String userAttributeName){
    return MoEDAO.getInstance(context).getUserAttributeByName(userAttributeName);
  }


  static String getBatchId(){
    return String.valueOf(MoEUtils.currentTime()) + "-" + UUID.randomUUID().toString();
  }

  static String getTimeInISO(long timeMillis){
    Date currentDate = new Date();
    currentDate.setTime(timeMillis);
    return ISO8601Utils.format(currentDate);
  }

  public static String getSha1ForString(String inputString){
    try {
      MessageDigest md = MessageDigest.getInstance("SHA-1");
      md.update(inputString.getBytes());
      return bytesToHex(md.digest());
    } catch (Exception e) {
      Logger.f(  "MoEUtils getSha1ForString() : Exception ", e);
    }
    return inputString;
  }

  private final static char[] hexArray = "0123456789ABCDEF".toCharArray();

  private static String bytesToHex(byte[] bytes) {
    char[] hexChars = new char[bytes.length * 2];
    for (int j = 0; j < bytes.length; j++) {
      int v = bytes[j] & 0xFF;
      hexChars[j * 2] = hexArray[v >>> 4];
      hexChars[j * 2 + 1] = hexArray[v & 0x0F];
    }
    return new String(hexChars);
  }

  @Nullable
  public static String getAppId(Context context){
    String appId = ConfigurationProvider.getInstance(context).getAppId();
    if (TextUtils.isEmpty(appId)) return null;
    boolean DEBUG_ENABLED =
        (0 != (context.getApplicationInfo().flags & ApplicationInfo.FLAG_DEBUGGABLE));
    if (DEBUG_ENABLED) {
      appId += "_DEBUG";
    }
    return appId;

  }

  public static long currentTime(){
    return System.currentTimeMillis();
  }

  public static String getCurrentISOTime(){
    return getTimeInISO(MoEUtils.currentTime());
  }

  @Nullable @WorkerThread
  public static String getUserAttributeUniqueId(Context context) {
    try {
      MoEAttribute attribute = MoEDAO.getInstance(context).getAttributeByName(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID);
      if (attribute != null) return attribute.getValue();
      return ConfigurationProvider.getInstance(context).getUserAttributeUniqueId();
    } catch (Exception e) {
      Logger.f(TAG + " getUserAttributeUniqueId() : ");
    }
    return null;
  }

  @Nullable
  public static String convertListToString(List<String> stringList, @NonNull String separator){
    if (stringList == null) return null;
    int length = stringList.size();
    StringBuilder builder = new StringBuilder();
    try {
      for (int i = 0; i < length; i++) {
        builder.append(stringList.get(i));
        if (i != length - 1) {
          builder.append(separator);
        }
      }
      return builder.toString();
    } catch (Exception e) {
      Logger.f("MoEUtils: convertListToString", e);
    }
    return null;
  }


  @Nullable
  public static MoEAttribute convertJsonToAttributeObject(JSONObject attributeJson) throws
      JSONException {
    Iterator jsonKeys = attributeJson.keys();
    if (jsonKeys.hasNext()){
      String attributeName = (String) jsonKeys.next();
      Object attributeValue = attributeJson.get(attributeName);
      return new MoEAttribute(
          attributeName,
          attributeValue.toString(),
          MoEUtils.currentTime(),
          getDataTypeForObject(attributeValue).toString());
    }
    return null;
  }

  public static DataTypes getDataTypeForObject(Object value){
    if (value instanceof Integer){
      return DataTypes.INTEGER;
    }
    if (value instanceof Double){
      return DataTypes.DOUBLE;
    }
    if (value instanceof  Long){
      return DataTypes.LONG;
    }
    if (value instanceof Boolean){
      return DataTypes.BOOLEAN;
    }
    if (value instanceof Float){
      return DataTypes.FLOAT;
    }
    return DataTypes.STRING;
  }

  /**
   * Checks whether the given device is manufactured by Xiaomi or not.
   * @param manufacturer Device manufacturer.
   * @return true if it is a Xiaomi device, else false.
   */
  public static boolean isXiaomiDevice(String manufacturer){
    return MoEConstants.MANUFACTURER_XIAOMI.equals(manufacturer);
  }

  public static String deviceManufacturer(){
    return Build.MANUFACTURER;
  }

}
