/* ************************************************************************
 *
 * MOENGAGE CONFIDENTIAL
 * __________________
 *
 *  [2014] - [2015] MoEngage Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.core;

/**
 * @author MoEngage (abhishek@moengage.com)
 * @version 1.0
 * @since 5.0
 */
public final class MoEConstants {

  private MoEConstants() {
    // Utility class cannot be instantiated
  }

  // Associated with only v2 API RESPONSE
  /**
   * Attribute key for the status of the response received from a v2 API
   */
  static final String RESULT_ATTR_STATUS = "status";
  /**
   * Attribute value associated with {@link #RESULT_ATTR_STATUS} when it is a
   * successful response
   */
  static final String RESULT_ATTR_VALUE_SUCCESS = "success";
  /**
   * The value associated with the {@link #RESPONSE_ATTR_RESULT} which
   * indicates a successful API response. This is applicable for all version 1
   * APIs only
   */
  static final String RESULT_OK = "OK";
  /* ***************************** EVENT TRACKING STRINGS ************************************ */
  /**
   * Associated with Event Tracking. The Key for the JSON Object which holds
   * the value for the activity which is currently changing states
   * (start/stop). Associated to {@link #EVENT_ACTION_ACTIVITY_START} &
   * {@link #EVENT_ACTION_ACTIVITY_STOP}
   */
  static final String EVENT_ACTIVITY_NAME = "ACTIVITY_NAME";
	/* ***************************** PREFERNCE KEYS ************************************ */


  public static final String ATTR_MOE_GAID = "MOE_GAID";

  static final String ATTR_IS_LAT = "MOE_ISLAT";
  /**
   *
   */
  static final String PREF_KEY_INSTALL_LOGGED = "pref_installed";
  /**
   * <b>Event Tracking</b>. Denotes that the activity is being started.
   */
  public static final String EVENT_ACTION_ACTIVITY_START = "EVENT_ACTION_ACTIVITY_START";
  /**
   * <b>Event Tracking</b>. Denotes that activity is being stopped
   */
  static final String EVENT_ACTION_ACTIVITY_STOP = "EVENT_ACTION_ACTIVITY_STOP";
  /**
   * <b>Event Tracking</b>. Denotes that the event being logged is an user
   * attribute
   */
  public static final String EVENT_ACTION_USER_ATTRIBUTE = "EVENT_ACTION_USER_ATTRIBUTE";
  /**
   * <b>DEVICE ATTR Tracking</b>. Denotes that the event being logged is an user
   * attribute
   */
  static final String EVENT_ACTION_DEVICE_ATTRIBUTE = "EVENT_ACTION_DEVICE_ATTRIBUTE";
  /**
   * <b>Event Tracking</b>. Denotes that a coupon code was clicked
   */
  static final String EVENT_ACTION_COUPON_CODE_COPY = "EVENT_ACTION_COUPON_CODE_COPY";
  /**
   * <b>API response ATTRIBUTE</b>. The key associated with the response
   * result value. Associated with V1 API only
   */
  static final String RESPONSE_ATTR_RESULT = "result";

  /**
   * The URL associated with the version 2 of MoEngage General API
   */
  static final String API_GENERAL_V2 = "https://apiv2.moengage.com";

  /**
   * This is the GCM registration endpoint associated with the v1 API. This is
   * to be used with {@link #API_GENERAL_V2}
   */
  static final String API_ENDPOINT_DEVICE_ADD = "v2/sdk/device";
  /**
   * API end point which needs to be used for sending interaction report. This
   * is to be used with {@link #API_GENERAL_V2}
   */
  static final String API_ENDPOINT_REPORT_ADD = "/v2/sdk/report";

  /**
   * <b>API response ATTRIBUTE</b> which holds the events info
   */
  public static final String RESPONSE_ATTR_EVENTS_INFO = "event_list";
  /**
   * <b>API Param</b>. stating the last updated time stamp
   */
  public static final String PARAM_LAST_UPDATED = "last_updated";

  // GENERIC params which are associated to all api requests for api v1
  static final String GENERIC_PARAM_V1_KEY_GCM_ID = "gcmId";
  static final String GENERIC_PARAM_V1_KEY_APP_ID = "appId";
  static final String GENERIC_PARAM_V1_KEY_OS = "os_value";
  static final String GENERIC_PARAM_V1_VALUE_ANDROID = "ANDROID";
  static final String GENERIC_PARAM_V1_KEY_APP_VERSION = "version";
  static final String GENERIC_PARAM_V1_KEY_LIB_VERSION = "libVersion";
  static final String GENERIC_PARAM_KEY_NW_TYPE = "networkType";

  // API V2 generic params
  public static final String GENERIC_PARAM_V2_KEY_OS = "os";
  static final String GENERIC_PARAM_V2_KEY_GCM_ID = "push_id";
  public static final String GENERIC_PARAM_V2_KEY_APP_ID = "app_id";
  public static final String GENERIC_PARAM_V2_KEY_UUID = "unique_id";
  static final String GENERIC_PARAM_V2_KEY_ANDROID_ID = "android_id";
  public static final String GENERIC_PARAM_V2_KEY_APP_VERSION = "app_ver";
  static final String GENERIC_PARAM_V2_KEY_OS_VERSION = "os_ver";
  public static final String GENERIC_PARAM_V2_KEY_LIBVERSION = "sdk_ver";
  public static final String GENERIC_PARAM_V2_KEY_TIMESTAMP = "device_ts";
  public static final String GENERIC_PARAM_V2_KEY_TIMEZONE = "device_tz";
  public static final String GENERIC_PARAM_V2_KEY_TIMEZONE_OFFSET = "device_tz_offset";
  static final String GENERIC_PARAM_V2_KEY_MODEL = "model";
  public static final String GENERIC_PARAM_V2_KEY_APP_VERSION_NAME = "app_version_name";
  static final String GENERIC_PARAM_V2_KEY_GAID = "moe_gaid";
  public static final String GENERIC_PARAM_V2_KEY_PUSH_SERVER = "moe_push_ser";
  public static final String GENERIC_PARAM_V2_KEY_INTEGRATION_TYPE = "integration_type";
  public static final String PARAM_V2_KEY_MI_PUSH_TOKEN = "mi_push_id";

  //generic params values
  public static final String GENERIC_PARAM_V2_VALUE_OS = "ANDROID";
  public static final String GENERIC_PARAM_V2_VALUE_PUSH_SERVER_ANDROID = "android";
  public static final String GENERIC_PARAM_V2_VALUE_PUSH_SERVER_BAIDU = "baidu";
  /**
   * Attribute stating the count of number of interaction points
   */
  static final String ATTR_INTERACTION_VIEWS_COUNT = "viewsCount";
  /**
   * Attribute which holds all the interaction points
   */
  static final String ATTR_INTERACTION_VIEWS_INFO = "viewsInfo";
  /**
   * The exponential counter for exponential back off
   */
  static final String EXPONENTIAL_CONSTANT_MOE = "PREF_EXPONENTIAL_BACK_OFF";

  static final String PREF_KEY_DEVICE_ADD_SCHEDULED = "PREF_DEVICE_ADD_SCHEDULED";

  /**
   * Delimiter for events in the { SMART_ACTIONS} list.
   */
  public static final String EVENT_SEPARATOR = ";";
  /**
   * Post request array property name which has the list of all local campaigns
   */
  public static final String REQ_ATTR_CAMPAIGN_LIST = "campaign_ids";

  public static boolean dbUpdateRequired = true;

  public static final String API_ENDPOINT_CONFIG_API = "v3/sdkconfig/android/";

  static final String API_V2_INDIA = "https://apiv2mumbai.moengage.com";

  static final String API_ENDPOINT_INTEGRATION_VERIFICATION_DEVICE_REGISTRATION =
      "/integration/register_device";

  static final String API_ENDPOINT_INTEGRATION_VERIFICATION_REPORT_ADD =
      "/integration/send_report_add_call";

  static final String API_ENDPOINT_INTEGRATION_VERIFICATION_UNLINK_DEVICE =
      "/integration/unregister_device";

  static final String LOGOUT_EVENT =  "MOE_LOGOUT";

  static final String ATTR_SDK_IDENTIFIERS = "identifiers";

  static final String ATTR_MOE_USER_ID = "moe_user_id";

  static final String ATTR_SEGMENT_ID = "segment_id";

  static final String API_V2_EU = "https://apiv2eu.moengage.com";

  static final String SERVICE_TYPE_LOGOUT = "LOGOUT";

  public static final String SERVICE_TYPE_APP_UPDATE = "APP_UPDATE";

  static final String SERVICE_LOGOUT_TYPE = "IS_FORCE_LOGOUT";

  static final String ATTR_BATCH_ID = "bid";

  static final String ATTR_SDK_META = "meta";

  static final String REQUEST_ATTR_DEVICE_PREFERENCE = "dev_pref";

  static final String REQUEST_ATTR_PUSH_PREFERENCE = "push_p";

  static final String REQUEST_ATTR_IN_APP_PREFERENCE = "in_app_p";

  static final String REQUEST_ATTR_REQUEST_TIME = "request_time";

  static final String REQUEST_ATTR_REQUEST_ID = "request_id";

  static final String REQUEST_ATTR_DATA_TRACKING_PREFERENCE = "e_t_p";

  static final String MOE_APP_EXIT_EVENT = "MOE_APP_EXIT";

  public static final String PUSH_REGISTRATION_ATTRIBUTE = "moe_p_reg";

  static final String REQUEST_HEADER_REQUEST_ID = "MOE-REQUEST-ID";

  public static final String REQUEST_HEADER_APP_KEY = "MOE-APPKEY";

  static final String REQUEST_ATTR_QUERY_PARAMS = "query_params";

  public static final String AUTHORITY_API_V2_US = "apiv2.moengage.com";

  public static final String AUTHORITY_API_V2_EU = "apiv2eu.moengage.com";

  public static final String AUTHORITY_API_V2_INDIA = "apiv2mumbai.moengage.com";

  public static final String INTEGRATION_TYPE_SEGMENT = "segment";

  static final String PUSH_SERVICE_FCM = "FCM";

  static final String PUSH_SERVICE_MI_PUSH = "MI_PUSH";

  static final String MANUFACTURER_XIAOMI = "Xiaomi";

  public static final String SHOW_NOTIFICATION = "SHOW_NOTIFICATION";

}
