package com.moengage.core.mipush;

import android.app.Application;
import com.moengage.core.Logger;

/**
 * @author Umang Chamaria
 */
public class MiPushManager {

  private static final String TAG = "MiPushManager";

  private MiPushHandler miPushHandler;

  private static MiPushManager _INSTANCE;

  private MiPushManager(){
    loadHandler();
  }

  private void loadHandler(){
    try {
      Class handler = Class.forName("com.moengage.mi.MiPushHandlerImpl");
      miPushHandler = (MiPushHandler) handler.newInstance();
    }catch (Exception e){
      Logger.e( TAG + " loadHandler() : Did not find Mi Push Module. ", e);
    }
  }

  public static MiPushManager getInstance(){
    if (_INSTANCE == null){
      _INSTANCE = new MiPushManager();
    }
    return _INSTANCE;
  }

  public void initMiPush(Application application){
    if (miPushHandler != null){
      miPushHandler.initMiPushIfRequired(application);
    }
  }
}
