package com.moengage.core;

import java.util.regex.Pattern;

/**
 * @author Umang Chamaria
 */
public class MoECoreEvaluator {

  private static final String TAG = "MoECoreEvaluator";

  public boolean isValidUniqueId(String uniqueIdRegexList, String trackedUniqueId){
    try {
      if (uniqueIdRegexList == null) return true;
      String[] regexArray = uniqueIdRegexList.split(MoEConstants.EVENT_SEPARATOR);
      for (String regex : regexArray) {
        if (Pattern.matches(regex, trackedUniqueId)){
          return false;
        }
      }
    } catch (Exception e) {
      Logger.e(TAG + " isValidUniqueId() : Exception: ", e);
    }
    return true;
  }
}
