package com.moengage.core;

import android.support.annotation.Nullable;
import java.util.HashMap;

/**
 * @author Umang Chamaria
 */
public class ConfigurationCache {

  private HashMap<String, Object> configMap;

  private static ConfigurationCache instance;

  private ConfigurationCache() {
    configMap = new HashMap<>();
  }

  public static ConfigurationCache getInstance() {
    if (instance == null) {
      synchronized (ConfigurationCache.class) {
        if (instance == null) instance = new ConfigurationCache();
      }
    }
    return instance;
  }

  private static final String MI_APP_KEY = "mi_app_key";

  void saveMiAppKey(String miAppKey) {
    configMap.put(MI_APP_KEY, miAppKey);
  }

  @Nullable
  public String getMiAppKey() {
    if (configMap.containsKey(MI_APP_KEY)) {
      return (String) configMap.get(MI_APP_KEY);
    }
    return null;
  }

  private static final String MI_APP_ID = "mi_app_id";

  void saveMiAppId(String miAppId) {
    configMap.put(MI_APP_ID, miAppId);
  }

  @Nullable
  public String getMiAppId() {
    if (configMap.containsKey(MI_APP_ID)) {
      return (String) configMap.get(MI_APP_ID);
    }
    return null;
  }

  private static final String MI_PUSH_STATE = "mi_push_state";

  void setMiPushState(boolean miPushState) {
    configMap.put(MI_PUSH_STATE, miPushState);
  }

  public boolean isMiPushEnabled() {
    return configMap.containsKey(MI_PUSH_STATE) && configMap.get(MI_PUSH_STATE) ==
        Boolean.TRUE;
  }

  private static final String PUSH_SERVICE = "push_service";

  public void setPushService(String pushService) {
    configMap.put(PUSH_SERVICE, pushService);
  }

  public String getPushService() {
    String pushService = MoEConstants.PUSH_SERVICE_FCM;
    if (configMap.containsKey(PUSH_SERVICE)) {
      pushService = (String) configMap.get(PUSH_SERVICE);
    }
    return pushService;
  }

  private static final String BAIDU_PUSH_STATE = "baidu_push_state";

  void setBaiduPushState(boolean baiduPushState) {
    configMap.put(BAIDU_PUSH_STATE, baiduPushState);
  }

  public boolean getBaiduPushState() {
    return configMap.containsKey(BAIDU_PUSH_STATE)
        && configMap.get(BAIDU_PUSH_STATE) == Boolean.TRUE;
  }

  // push navigation action back-stack opt out
  private static final String BACK_STACK_OPT_OUT = "is_back_stack_opted_out";

  public void setBackStackOptOut(boolean backStackOptOut) {
    configMap.put(BACK_STACK_OPT_OUT, backStackOptOut);
  }

  public boolean isBackStackOptedOut() {
    return configMap.containsKey(BACK_STACK_OPT_OUT)
        && configMap.get(BACK_STACK_OPT_OUT) == Boolean.TRUE;
  }

  private static final String EXTRAS_OPT_OUT = "is_extras_opted_out";

  public void setExtrasOptOut(boolean extrasOptOut) {
    configMap.put(EXTRAS_OPT_OUT, extrasOptOut);
  }

  public boolean isExtrasOptedOut() {
    return configMap.containsKey(EXTRAS_OPT_OUT) && configMap.get(EXTRAS_OPT_OUT) == Boolean.TRUE;
  }

  private static final String OPT_OUT_DEFAULT_INAPP = "is_default_inapp_opted_out";

  public void setDefaultInAppOptOut(boolean defaultInAppOptOut) {
    configMap.put(OPT_OUT_DEFAULT_INAPP, defaultInAppOptOut);
  }

  public boolean isDefaultInAppOptedOut() {
    return configMap.containsKey(OPT_OUT_DEFAULT_INAPP)
        && configMap.get(OPT_OUT_DEFAULT_INAPP) == Boolean.TRUE;
  }
}
