/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.utils;

import android.content.Context;
import android.net.Uri;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.utils.JsonBuilder;
import com.moengage.push.PushManager;
import java.util.TimeZone;
import org.json.JSONException;

public class RestUtils {
    public static String getAuthority(Context context) {
        int region = ConfigurationProvider.getInstance(context).getDataRegion();
        if (region == -999) {
            return "apiv2.moengage.com";
        }
        switch (region) {
            case 1003: {
                return "apiv2.moengage.com";
            }
            case 1002: {
                return "apiv2eu.moengage.com";
            }
            case 1001: {
                return "apiv2mumbai.moengage.com";
            }
        }
        return "apiv2.moengage.com";
    }

    public static RequestBuilder getBaseRequestBuilder(Uri uri, RequestBuilder.RequestType requestType, String appId) {
        return new RequestBuilder(uri, requestType).addHeader("MOE-APPKEY", appId);
    }

    public static JsonBuilder getDefaultParams(Context context) throws JSONException {
        JsonBuilder params = new JsonBuilder();
        long currentTime = MoEUtils.currentTime();
        params.putString("os", "ANDROID").putString("app_id", MoEUtils.getAppId(context)).putString("sdk_ver", String.valueOf(9302)).putString("unique_id", ConfigurationProvider.getInstance(context).getCurrentUserId()).putLong("device_ts", currentTime).putLong("device_tz_offset", TimeZone.getDefault().getOffset(currentTime));
        if (ConfigurationProvider.getInstance(context).isSegmentEnabled()) {
            params.putString("integration_type", "segment");
        }
        if (PushManager.getInstance().isIsBaiduEnabled()) {
            params.putString("moe_push_ser", "baidu");
        } else {
            params.putString("moe_push_ser", "android");
        }
        return params;
    }

    public static Uri.Builder getBaseUriBuilder(Context context) {
        return new Uri.Builder().scheme("https").authority(RestUtils.getAuthority(context));
    }
}

