/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ActivityStartTask;
import com.moengage.core.ActivityStopTask;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.CreatingDataBatchTask;
import com.moengage.core.DeviceAddTask;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEWorkerTask;
import com.moengage.core.NotificationClickedTask;
import com.moengage.core.OnJobComplete;
import com.moengage.core.SetAliasTask;
import com.moengage.core.SetDeviceAttributeTask;
import com.moengage.core.TrackEventTask;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.listeners.OnAppBackgroundListener;
import com.moengage.core.listeners.OnLogoutCompleteListener;
import com.moengage.core.remoteconfig.ConfigApiNetworkTask;
import com.moengage.core.userattributes.MoEAttributeManager;
import com.moengage.inapp.InAppController;
import com.moengage.location.GeoManager;
import com.moengage.push.MoEMessagingManager;
import com.moengage.push.PushManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class MoEDispatcher
implements OnTaskCompleteListener {
    private static final String TAG = "MoEDispatcher";
    private Context mContext;
    private ConfigurationProvider configProvider;
    private TaskProcessor mTaskProcessor;
    private static MoEDispatcher _INSTANCE;
    private boolean shouldClearData = false;
    private HashMap<String, Boolean> runningTaskList;
    private boolean mNeedToCheckForGAIDChange = true;
    private boolean shouldTrackUniqueId = false;
    private JSONObject uniqueIdAttribute = null;
    private ScheduledExecutorService mScheduler;
    private OnLogoutCompleteListener logoutCompleteListener;
    private MoEAttributeManager attributeManager = null;
    private final Object lock = new Object();
    private List<String> optedOutActivities;

    private MoEDispatcher(Context context) {
        if (context != null) {
            this.mContext = context;
            this.configProvider = ConfigurationProvider.getInstance(this.mContext);
            this.mTaskProcessor = TaskProcessor.getInstance();
            this.runningTaskList = new HashMap();
            this.mTaskProcessor.setOnTaskCompleteListener(this);
            this.attributeManager = new MoEAttributeManager(context);
        } else {
            Logger.e("MoEDispatcher  : context is null");
        }
    }

    public static MoEDispatcher getInstance(Context context) {
        if (_INSTANCE == null) {
            _INSTANCE = new MoEDispatcher(context);
        }
        return _INSTANCE;
    }

    public void checkForInAppMessages(boolean force) {
        if (!this.configProvider.isInAppEnabled() || !this.configProvider.isAppEnabled()) {
            return;
        }
        Logger.v("MoEDispatcher: showInAppIfPossible: Check in app messages");
        if (force) {
            InAppController.getInstance().showInAppIfEligible(this.mContext);
        }
    }

    public void onStart(Activity activity, Intent intent) {
        Bundle extras;
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        if (null == activity) {
            Logger.e("MoEDispatcher:onStart activity instance is null");
            return;
        }
        if (null == intent) {
            intent = activity.getIntent();
        }
        this.mContext = activity.getApplicationContext();
        Logger.v("MoEDispatcher:onStart ----");
        MoEHelperUtils.dumpIntentExtras(intent);
        String currentActivityName = activity.getClass().getName();
        if (!this.isActivityOptedOut(activity)) {
            this.addTaskToQueue(new ActivityStartTask(this.mContext, currentActivityName, this.mNeedToCheckForGAIDChange));
        }
        Context context = activity.getApplicationContext();
        int currentOrientation = context.getResources().getConfiguration().orientation;
        String savedActivityName = InAppController.getInstance().getActivityName();
        int savedOrientation = InAppController.getInstance().getActivityOrientation();
        if (savedActivityName != null && savedOrientation != -1) {
            if (savedActivityName.equals(currentActivityName) && savedOrientation != currentOrientation) {
                InAppController.getInstance().showInAppOnConfigurationChange(this.mContext);
            } else {
                this.saveCurrentActivityDetails(currentActivityName, currentOrientation);
                this.syncInAppsAndGeo();
            }
        } else {
            this.saveCurrentActivityDetails(currentActivityName, currentOrientation);
            this.syncInAppsAndGeo();
        }
        this.saveCurrentActivityDetails(currentActivityName, currentOrientation);
        if (intent != null && (extras = intent.getExtras()) != null) {
            extras.remove("nav_provier");
            extras.remove("nav_source");
            PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
            if (pushHandler != null) {
                pushHandler.logNotificationClicked(context, intent);
            }
        }
        if (MoEHelper.getActivityCounter() == 1) {
            this.pushTokenFallBack();
        }
        MoEUtils.updateTestDeviceState(this.mContext);
    }

    private void pushTokenFallBack() {
        PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        if (pushHandler != null) {
            pushHandler.setPushRegistrationFallback(this.mContext);
        }
    }

    private void syncInAppsAndGeo() {
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        Logger.v("MoEDispatcher: Fetch or query in app message");
        InAppController.getInstance().showInAppIfEligible(this.mContext);
        GeoManager.getInstance().updateFenceAndLocation(this.mContext);
    }

    public void trackNotificationClicked(long gtime) {
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        this.addTaskToQueue(new NotificationClickedTask(this.mContext, gtime));
    }

    public void setUserAttribute(JSONObject userJson) {
        this.attributeManager.setUserAttribute(userJson);
    }

    public void setCustomUserAttribute(JSONObject userJson) {
        this.attributeManager.setCustomUserAttribute(userJson);
    }

    public void setExistingUser(boolean existing, Context context) {
        try {
            if (!this.configProvider.isAppEnabled()) {
                return;
            }
            boolean installRegistered = MoEUtils.isInstallRegistered(context);
            int currentVersion = this.configProvider.getAppVersion();
            if (existing) {
                int prevVersion = this.configProvider.getStoredAppVersion();
                if (currentVersion == prevVersion) {
                    return;
                }
                this.configProvider.storeAppVersion(currentVersion);
                JSONObject eventObj = new PayloadBuilder().putAttrInt("VERSION_FROM", prevVersion).putAttrInt("VERSION_TO", currentVersion).putAttrDate("UPDATED_ON", new Date()).build();
                MoEEventManager.getInstance(context).trackEvent("UPDATE", eventObj);
                Logger.v("MoEDispatcher:setExistingUser:tracking update");
            } else if (!installRegistered) {
                this.configProvider.storeAppVersion(currentVersion);
                PayloadBuilder builder = new PayloadBuilder();
                String referrer = MoEHelperUtils.getInstallReferrer(context);
                if (!TextUtils.isEmpty((CharSequence)referrer)) {
                    builder.putAttrString("INSTALL_REFERRER_MOE", referrer);
                }
                builder.putAttrInt("VERSION", currentVersion).putAttrInt("sdk_ver", 9302).putAttrLong("INSTALLED_TIME", System.currentTimeMillis()).putAttrString("os", "ANDROID");
                MoEEventManager.getInstance(context).trackEvent("INSTALL", builder.build());
                Logger.v("MoEDispatcher:setExistingUser:tracking install");
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: setExistingUser: ", e);
        }
    }

    void cancelRegistrationFallback() {
        MoEUtils.setRegistrationScheduled(this.mContext, false);
        MoEUtils.saveCurrentExponentialCounter(this.mContext, 1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void writeDataPointToStorage(Event event) {
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        this.addTaskToQueue(new TrackEventTask(this.mContext, event));
    }

    public void onResume(Activity activity, boolean isRestoring) {
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        if (!isRestoring) {
            this.showDialogAfterPushClick(activity);
        }
    }

    public void onStop(Activity activity, boolean configChange) {
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        if (null == activity) {
            return;
        }
        if (configChange) {
            return;
        }
        this.addTaskToQueue(new ActivityStopTask(this.mContext, activity.getClass().getName()));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void handleLogout(boolean isForcedLogout) {
        Logger.i("Started logout process");
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        this.trackLogoutEvent(isForcedLogout);
        this.sendInteractionData();
        this.shouldClearData = true;
    }

    private void trackLogoutEvent(boolean isForcedLogout) {
        try {
            JSONObject eventAttributes = new JSONObject();
            if (isForcedLogout) {
                eventAttributes.put("type", (Object)"forced");
            }
            Event event = new Event(MoEHelperUtils.getDatapointJSON("MOE_LOGOUT", eventAttributes));
            MoEDAO.getInstance(this.mContext).addEvent(event, this.mContext);
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: trackLogoutEvent(): ", e);
        }
    }

    @WorkerThread
    private void clearDataOnLogout() {
        this.mContext.getContentResolver().delete(MoEDataContract.DatapointEntity.getContentUri(this.mContext), null, null);
        this.mContext.getContentResolver().delete(MoEDataContract.MessageEntity.getContentUri(this.mContext), null, null);
        this.mContext.getContentResolver().delete(MoEDataContract.InAppMessageEntity.getContentUri(this.mContext), null, null);
        this.mContext.getContentResolver().delete(MoEDataContract.UserAttributeEntity.getContentUri(this.mContext), null, null);
        this.mContext.getContentResolver().delete(MoEDataContract.CampaignListEntity.getContentUri(this.mContext), null, null);
        this.mContext.getContentResolver().delete(MoEDataContract.BatchDataEntity.getContentUri(this.mContext), null, null);
        this.mContext.getContentResolver().delete(MoEDataContract.DTEntity.getContentUri(this.mContext), null, null);
        MoEDAO.getInstance(this.mContext).clearAttributeCache();
        this.configProvider.removeUserConfigurationOnLogout();
        this.configProvider.setDeviceRegistered(false);
        this.notifyLogoutCompleteListener();
        PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        if (pushHandler != null) {
            pushHandler.registerForPushToken(this.mContext);
        }
        this.shouldClearData = false;
        Logger.i("Completed logout process");
    }

    public void sendInteractionData() {
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        this.addTaskToQueue(new CreatingDataBatchTask(this.mContext));
    }

    public void sendInteractionData(OnJobComplete jobComplete, JobParameters parameters) {
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        this.addTaskToQueueBeginning(new CreatingDataBatchTask(this.mContext, jobComplete, parameters));
    }

    public void onFragmentStart(Activity activity, String fragmentName) {
        this.syncInAppsAndGeo();
    }

    @WorkerThread
    public void setInboxMessageClicked(long id2) {
        MoEDAO.getInstance(this.mContext).setMessageClicked(id2);
    }

    @WorkerThread
    void handleAppUpdateEvent() {
        try {
            if (!this.configProvider.isAppEnabled()) {
                return;
            }
            int prevVersion = this.configProvider.getStoredAppVersion();
            JSONObject eventObj = new JSONObject();
            eventObj.put("VERSION_FROM", prevVersion);
            eventObj.put("VERSION_TO", this.configProvider.getAppVersion());
            Event event = new Event(MoEHelperUtils.getDatapointJSON("UPDATE", eventObj));
            Logger.i("Adding an update event");
            MoEEventManager.getInstance(this.mContext).trackEvent("UPDATE", eventObj);
            if (!MoEHelper.isAppInForeground()) {
                this.sendInteractionData();
            }
        }
        catch (Exception e) {
            Logger.f("Adding update event", e);
        }
    }

    @Nullable
    @WorkerThread
    public Cursor getAllMessages() {
        return MoEDAO.getInstance(this.mContext).getMessages(this.mContext);
    }

    @WorkerThread
    public int getUnreadMessageCount() {
        return MoEDAO.getInstance(this.mContext).getUnreadMessageCount();
    }

    public void initialize(String senderId, String appId) {
        if (!TextUtils.isEmpty((CharSequence)appId)) {
            this.configProvider.saveAppDetails(senderId, appId);
            this.dispatchPushTask("MOE_REG_REQ");
        } else {
            Logger.e("MoEDispatcher: initialize : AppId is null");
        }
    }

    public void checkAndShowLinkedInApp(String campaignId) {
        InAppController.getInstance().fetchLinkedInApp(this.mContext, campaignId);
    }

    private void showDialogAfterPushClick(Activity activity) {
        if (null == activity) {
            return;
        }
        try {
            Bundle extras;
            Intent intent = activity.getIntent();
            if (intent != null && (extras = intent.getExtras()) != null && extras.containsKey("gcm_show_dialog")) {
                intent.removeExtra("gcm_show_dialog");
                if (extras.containsKey("gcm_coupon_code")) {
                    MoEUtils.showCouponDialog(extras.getString("gcm_alert"), extras.getString("gcm_coupon_code"), (Context)activity);
                    intent.removeExtra("gcm_alert");
                    intent.removeExtra("gcm_coupon_code");
                } else {
                    MoEUtils.showNormalDialogWithOk(extras.getString("gcm_alert"), (Context)activity);
                    intent.removeExtra("gcm_alert");
                }
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: showDialogAfterPushClick : ", e);
        }
    }

    private void saveCurrentActivityDetails(String currActivityName, int currentOrientation) {
        InAppController.getInstance().setActivityName(currActivityName);
        InAppController.getInstance().setActivityOrientation(currentOrientation);
    }

    public void addTaskToQueue(ITask task) {
        Logger.v("Trying to add " + task.getTaskTag() + " to the queue");
        if (task.isSynchronous()) {
            if (!this.runningTaskList.containsKey(task.getTaskTag())) {
                Logger.v(task.getTaskTag() + " added to queue");
                this.runningTaskList.put(task.getTaskTag(), task.isSynchronous());
                this.mTaskProcessor.addTask(task);
            }
        } else {
            Logger.v(task.getTaskTag() + " added to queue");
            this.runningTaskList.put(task.getTaskTag(), task.isSynchronous());
            this.mTaskProcessor.addTask(task);
        }
    }

    public void addTaskToQueueBeginning(ITask task) {
        Logger.v("Trying to add " + task.getTaskTag() + " to the queue");
        if (task.isSynchronous()) {
            if (!this.runningTaskList.containsKey(task.getTaskTag())) {
                Logger.v(task.getTaskTag() + " added to beginning of queue");
                this.runningTaskList.put(task.getTaskTag(), task.isSynchronous());
                this.mTaskProcessor.addTaskToFront(task);
            }
        } else {
            Logger.v(task.getTaskTag() + " added to beginning of queue");
            this.runningTaskList.put(task.getTaskTag(), task.isSynchronous());
            this.mTaskProcessor.addTaskToFront(task);
        }
    }

    @Override
    public void onTaskComplete(String tag, TaskResult taskResult) {
        Logger.v("Task completed : " + tag);
        if (this.runningTaskList.containsKey(tag)) {
            this.runningTaskList.remove(tag);
        }
        switch (tag) {
            case "START_ACTIVITY": {
                if (!taskResult.isSuccess()) break;
                this.mNeedToCheckForGAIDChange = (Boolean)taskResult.getPayload();
                break;
            }
            case "SEND_INTERACTION_DATA": {
                if (!this.shouldClearData) break;
                this.clearDataOnLogout();
                if (!this.shouldTrackUniqueId) break;
                this.trackChangedUniqueId();
                break;
            }
            case "TRACK_ATTRIBUTE": {
                if (taskResult.isSuccess()) break;
                this.shouldTrackUniqueId = true;
                this.uniqueIdAttribute = (JSONObject)taskResult.getPayload();
            }
        }
    }

    private void resetStates() {
        this.mNeedToCheckForGAIDChange = true;
    }

    private boolean isActivityOptedOut(Activity activity) {
        try {
            if (this.optedOutActivities == null) {
                this.optedOutActivities = this.configProvider.getTrackingOptedOutActivities();
            }
            if (this.optedOutActivities != null && this.optedOutActivities.contains(activity.getClass().getName())) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher#isActivityOptedOut Exception Occurred" + e);
        }
        return false;
    }

    private void dispatchPushTask(String extra) {
        PushManager.PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        if (pushHandler != null) {
            pushHandler.offLoadToWorker(this.mContext, extra);
        }
    }

    public void logPushFailureEvent(Context context, String e) {
    }

    private void syncConfigIfRequired() {
        if (this.configProvider.getLastConfigSyncTime() + 3600000L < MoEUtils.currentTime()) {
            this.addTaskToQueueBeginning(new ConfigApiNetworkTask(this.mContext));
        }
    }

    public void trackDeviceLocale() {
        try {
            if (!this.configProvider.isAppEnabled()) {
                return;
            }
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY", Locale.getDefault().getCountry());
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY_DISPLAY", Locale.getDefault().getDisplayCountry());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE", Locale.getDefault().getLanguage());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE_DISPLAY", Locale.getDefault().getDisplayLanguage());
            this.trackDeviceAndUserAttribute("LOCALE_DISPLAY", Locale.getDefault().getDisplayName());
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY_ ISO3", Locale.getDefault().getISO3Country());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE_ISO3", Locale.getDefault().getISO3Language());
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher : trackDeviceLocale", e);
        }
    }

    private void trackDeviceAndUserAttribute(String attrName, String attrValue) {
        try {
            JSONObject attribute = new JSONObject();
            attribute.put(attrName, (Object)attrValue);
            this.setUserAttribute(attribute);
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: trackDeviceAndUserAttribute() ", e);
        }
    }

    public void logoutUser(boolean isForcedLogout) {
        try {
            Bundle extras = new Bundle();
            extras.putBoolean("IS_FORCE_LOGOUT", isForcedLogout);
            this.addTaskToQueue(new MoEWorkerTask(this.mContext, "LOGOUT", extras));
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: logoutUser() ", e);
        }
    }

    private void trackChangedUniqueId() {
        if (this.uniqueIdAttribute != null) {
            this.setUserAttribute(this.uniqueIdAttribute);
            this.uniqueIdAttribute = null;
            this.shouldTrackUniqueId = false;
        }
    }

    public void setAlias(JSONObject aliasJSON) {
        if (!this.configProvider.isAppEnabled()) {
            return;
        }
        this.addTaskToQueue(new SetAliasTask(this.mContext, aliasJSON));
    }

    public void setDeviceAttribute(JSONObject deviceAttribute) {
        this.addTaskToQueue(new SetDeviceAttributeTask(this.mContext, deviceAttribute));
    }

    private void schedulePeriodicFlushIfRequired() {
        try {
            if (this.configProvider.isPeriodicFlushEnabled() && MoEHelper.getInstance(this.mContext).getPeriodicSyncState()) {
                Runnable syncRunnable = new Runnable(){

                    @Override
                    public void run() {
                        Logger.v("MoEDispatcher: schedulePeriodicFlushIfRequired() inside runnable, will sync now");
                        MoEDispatcher.this.sendInteractionData();
                    }
                };
                long timeDelay = this.configProvider.getPeriodicFlushTime();
                if (MoEHelper.getInstance(this.mContext).getFlushInterval() > timeDelay) {
                    timeDelay = MoEHelper.getInstance(this.mContext).getFlushInterval();
                }
                Logger.v("MoEDispatcher: schedulePeriodicFlushIfRequired() scheduling periodic sync");
                this.mScheduler = Executors.newScheduledThreadPool(1);
                this.mScheduler.scheduleWithFixedDelay(syncRunnable, timeDelay, timeDelay, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            Logger.e("MoEDispatcher: schedulePeriodicFlushIfRequired() ", e);
        }
    }

    private void shutDownPeriodicFlush() {
        try {
            if (this.configProvider.isPeriodicFlushEnabled() && MoEHelper.getInstance(this.mContext).getPeriodicSyncState() && this.mScheduler != null) {
                Logger.v("MoEDispatcher: shutDownPeriodicFlush() shutting down periodic flush");
                this.mScheduler.shutdownNow();
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: shutDownPeriodicFlush() ", e);
        }
    }

    public void onAppOpen() {
        try {
            PushManager.PushHandler pushHandler;
            this.syncConfigIfRequired();
            InAppController.getInstance().syncInAppIfRequired(this.mContext);
            MoEMessagingManager.MessagingHandler messagingHandler = MoEMessagingManager.getInstance().getMessagingHandler(this.mContext);
            if (messagingHandler != null) {
                messagingHandler.forceMessageSync(this.mContext, true);
            }
            if ((pushHandler = PushManager.getInstance().getPushHandler()) != null) {
                pushHandler.offLoadToWorker(this.mContext, "REG_ON_APP_OPEN");
            }
            this.schedulePeriodicFlushIfRequired();
            MoEDTManager.getInstance().forceSyncDeviceTriggers(this.mContext);
            this.updateFeatureConfigForOptOutIfRequired();
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: onAppOpen() ", e);
        }
    }

    void updateFeatureConfigForOptOutIfRequired() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.mContext);
        if (provider.isDataTrackingOptedOut()) {
            provider.optOutOfAdIdCollection(true);
            provider.optOutOfAndroidIdCollection(true);
            provider.optOutOfIMEICollection(true);
            provider.optOutOfTrackLocation(true);
            provider.optOutOfSetGeoFence(true);
            provider.optOutOfDeviceAttributesCollection(true);
            provider.setLocationServicesState(false);
        }
        if (provider.isPushNotificationOptedOut()) {
            provider.setGCMToken("");
        }
    }

    public void setOnLogoutCompleteListener(OnLogoutCompleteListener listener) {
        this.logoutCompleteListener = listener;
    }

    public void removeOnLogoutCompleteListener() {
        this.logoutCompleteListener = null;
    }

    private void notifyLogoutCompleteListener() {
        Logger.v("MoEDispatcher notifyLogoutCompleteListener() : ");
        if (this.logoutCompleteListener != null) {
            this.logoutCompleteListener.logoutComplete();
        }
    }

    private void retryDeviceAddIfRequired() {
        Logger.v("MoEDispatcher retryDeviceAddIfRequired(): Will try to register device if required.");
        if (!this.configProvider.isDeviceRegistered() && !TextUtils.isEmpty((CharSequence)this.configProvider.getGCMToken())) {
            Logger.v("MoEDispatcher retryDeviceAddIfRequired() Will try to make a device add call again.");
            this.addTaskToQueue(new DeviceAddTask(this.mContext));
        }
    }

    void onAppClose() {
        Logger.v("MoEDispatcher onAppClose(): Application going to background.");
        this.notifyOnAppBackground();
        this.retryDeviceAddIfRequired();
        this.shutDownPeriodicFlush();
        InAppController.getInstance().writeInAppCheckFailureCounterToStorage(this.mContext);
        MoEDTManager.getInstance().scheduleBackgroundSync(this.mContext);
        this.resetStates();
        this.configProvider.storeSentScreenList();
        MoEMessagingManager.MessagingHandler messagingHandler = MoEMessagingManager.getInstance().getMessagingHandler(this.mContext);
        if (messagingHandler != null) {
            messagingHandler.scheduleMessageSync(this.mContext);
        }
        this.trackAppExitIfRequired();
    }

    private void notifyOnAppBackground() {
        OnAppBackgroundListener listener = MoEHelper.getInstance(this.mContext).getOnAppBackgroundListener();
        if (listener != null) {
            listener.goingToBackground();
        } else {
            Logger.v("MoEDispatcher execute() : on app background listener not set cannot provide callback");
        }
    }

    private void trackAppExitIfRequired() {
        if (ConfigurationProvider.getInstance(this.mContext).shouldTrackAppExit()) {
            MoEHelper.getInstance(this.mContext).trackEvent("MOE_APP_EXIT");
        }
    }

    public MoEAttributeManager getAttributeManager() {
        return this.attributeManager;
    }
}

