package com.moengage.core.remoteconfig;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.APIResponse;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

/**
 * @author Umang Chamaria
 */
public class ConfigApiNetworkTask extends SDKTask{
  private static final String TAG = "ConfigApiNetworkTask";
  private Context mContext;

  public ConfigApiNetworkTask(Context context){
    super(context);
    mContext = context;
  }

  @Override public TaskResult execute() {
    Logger.v("ConfigApiNetworkTask : executing Task");
    try {
      String appId = MoEUtils.getAppId(mContext);
      if (TextUtils.isEmpty(appId)){
        Logger.e(TAG + " execute(): Cannot make config api sync request without app id.");
        return null;
      }
      APIResponse response = APIManager.syncConfig(mContext,
          MoEUtils.getAPIRoute(mContext) + MoEConstants.API_ENDPOINT_CONFIG_API + appId);
      RemoteConfigResponseHandler handler = new RemoteConfigResponseHandler();
      handler.handleConfigApiResponse(mContext, response);

      MoEEventManager.getInstance(mContext).updateEventListFromRemote();
    } catch (Exception e) {
      Logger.f("ConfigApiNetworkTask : execute", e);
    }
    Logger.v("ConfigApiNetworkTask : execution completed");
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_SYNC_CONFIG_API;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
