package com.moengage.core.listeners;

/**
 * Callback listener trigger whenever the application goes to background.
 * Usage: <br>
 * Setting listener
 * <pre>
 *   <code>
 *     MoEHelper.getInstance(mContext).registerAppBackgroundListener(listener);
 *   </code>
 * </pre>
 * Remove Listener
 * <pre>
 *   <code>
 *     MoEHelper.getInstance(mContext).unregisterAppBackgroundListener()
 *   </code>
 * </pre>
 *
 * @author Umang Chamaria
 * @since 9.2.01
 */
public interface OnAppBackgroundListener {
  void goingToBackground();
}
