/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.rest;

import android.net.Uri;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.exceptions.InvalidRequestException;
import com.moengage.core.rest.exceptions.UTF8EncodingException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class RequestBuilder {
    private RequestType requestType;
    private Map<String, String> headersMap;
    private JSONObject jsonBody;
    private String contentType;
    private Uri uri;

    public RequestBuilder(Uri uri, RequestType requestType) {
        this.uri = uri;
        this.requestType = requestType;
        this.headersMap = new HashMap<String, String>();
        this.contentType = "application/json";
    }

    public RequestBuilder addHeader(String headerKey, String headerValue) {
        this.headersMap.put(headerKey, headerValue);
        return this;
    }

    public RequestBuilder addHeaders(Map<String, String> headersMap) {
        this.headersMap.putAll(headersMap);
        return this;
    }

    public RequestBuilder addBody(JSONObject jsonBody) {
        this.jsonBody = jsonBody;
        return this;
    }

    public RequestBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Request build() throws UTF8EncodingException, InvalidRequestException {
        if (this.requestType == RequestType.GET && this.jsonBody != null) {
            throw new InvalidRequestException("GET request cannot have a body.");
        }
        return new Request(this.uri, this.requestType, this.headersMap, this.jsonBody, this.contentType);
    }

    public static enum RequestType {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

