package com.moengage.core.utils;

import android.content.Context;
import android.net.Uri;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.RequestBuilder.RequestType;
import com.moengage.core.rest.RestConstants;
import com.moengage.push.PushManager;
import java.util.TimeZone;
import org.json.JSONException;

public class RestUtils {

  public static String getAuthority(Context context) {
    int region = ConfigurationProvider.getInstance(context).getDataRegion();
    if (region == -999) return MoEConstants.AUTHORITY_API_V2_US;
    switch (region) {
      case MoEHelperConstants.MOE_REGION_DEFAULT:
        return MoEConstants.AUTHORITY_API_V2_US;
      case MoEHelperConstants.MOE_REGION_EU:
        return MoEConstants.AUTHORITY_API_V2_EU;
      case MoEHelperConstants.MOE_REGION_INDIA:
        return MoEConstants.AUTHORITY_API_V2_INDIA;
      default:
        return MoEConstants.AUTHORITY_API_V2_US;
    }
  }

  public static RequestBuilder getBaseRequestBuilder(Uri uri, RequestType
      requestType, String appId) {
    return new RequestBuilder(uri, requestType).addHeader(
        MoEConstants.REQUEST_HEADER_APP_KEY, appId);
  }


  public static JsonBuilder getDefaultParams(Context context) throws JSONException {
    JsonBuilder params = new JsonBuilder();
    long currentTime = MoEUtils.currentTime();
    params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_OS, MoEConstants.GENERIC_PARAM_V2_VALUE_OS)
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_APP_ID, MoEUtils.getAppId(context))
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_LIBVERSION,
            String.valueOf(MoEHelperConstants.LIB_VERSION))
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_UUID,
            ConfigurationProvider.getInstance(context).getCurrentUserId())
        .putLong(MoEConstants.GENERIC_PARAM_V2_KEY_TIMESTAMP, currentTime)
        .putLong(MoEConstants.GENERIC_PARAM_V2_KEY_TIMEZONE_OFFSET,
            TimeZone.getDefault().getOffset(currentTime));
    if (ConfigurationProvider.getInstance(context).isSegmentEnabled()) {
      params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_INTEGRATION_TYPE,
          MoEConstants.INTEGRATION_TYPE_SEGMENT);
    }
    if (PushManager.getInstance().isIsBaiduEnabled()) {
      params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_PUSH_SERVER,
          MoEConstants.GENERIC_PARAM_V2_VALUE_PUSH_SERVER_BAIDU);
    } else {
      params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_PUSH_SERVER,
          MoEConstants.GENERIC_PARAM_V2_VALUE_PUSH_SERVER_ANDROID);
    }
    return params;
  }

  public static Uri.Builder getBaseUriBuilder(Context context){
    return new Uri.Builder()
        .scheme(RestConstants.SCHEME_HTTPS)
        .authority(RestUtils.getAuthority(context));
  }
}