package com.moengage.core.remoteconfig;

import android.content.Context;
import com.moengage.core.APIResponse;
import com.moengage.core.ApiResponseUtility;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.RemoteConfiguration;

/**
 * @author Umang Chamaria
 */
class RemoteConfigResponseHandler {

  private static final String TAG = "RemoteConfigResponseHandler";

  private RemoteConfigResponseParser responseParser;

  RemoteConfigResponseHandler(){
    responseParser = new RemoteConfigResponseParser();
  }

  boolean handleConfigApiResponse(Context context, APIResponse response){
    try {
      if (!ApiResponseUtility.isValidResponse(response)){
        Logger.e( TAG + " handleConfigApiResponse() : Not a valid api response ");
        return false;
      }
      //update remote configuration
      RemoteConfiguration remoteConfiguration = responseParser.parseConfigApiResponse(response);
      if (remoteConfiguration != null){
        MoEDAO.getInstance(context).addOrUpdateRemoteConfiguration(remoteConfiguration);
      }
      //update last sync time
      MoEDAO.getInstance(context).updateConfigApiSyncTime(MoEUtils.currentTime());
      return true;
    }catch (Exception e){
      Logger.f( TAG + " handleConfigApiResponse() : ");
    }
    return false;
  }
}
