package com.moengage.core;

import android.content.Context;
import android.os.Build;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.HashMap;

/**
 * @author Umang Chamaria
 */

public class IntegrationVerificationNetworkCallTask extends SDKTask {
  private TASK_TYPE task_type;

  public IntegrationVerificationNetworkCallTask(Context context, TASK_TYPE task_type) {
    super(context);
    this.task_type = task_type;
  }

  @Override public TaskResult execute() {
    try {
      switch (task_type) {
        case REGISTER_DEVICE:
         createResult(registerDevice());
          break;
        case UNREGISTER_DEVICE:
          createResult(unregisterDevice());
          break;
        default:
          Logger.e("IntegrationVerificationNetworkCallTask: invalid case");
      }
    } catch (Exception e) {
      Logger.f("IntegrationVerificationNetworkCallTask: Exception ", e);
    }
    return mTaskResult;
  }

  private APIResponse unregisterDevice() {
    String API = MoEUtils.getAPIRoute(mContext)
        + MoEConstants.API_ENDPOINT_INTEGRATION_VERIFICATION_UNLINK_DEVICE;
    return APIManager.registerUnregisterDeviceForIntegrationVerification(mContext, API, null);
  }

  private APIResponse registerDevice() {
    String API = MoEUtils.getAPIRoute(mContext)
        + MoEConstants.API_ENDPOINT_INTEGRATION_VERIFICATION_DEVICE_REGISTRATION;
    GeoLocation geoLocation =
        ConfigurationProvider.getInstance(mContext).getLastKnownUserLocation();
    if (geoLocation == null) {
      geoLocation = new GeoLocation(0.0, 0.0);
    }
    HashMap<String, String> paramsMap = new HashMap<>();
    paramsMap.put("lat", String.valueOf(geoLocation.latitude));
    paramsMap.put("lng", String.valueOf(geoLocation.longitude));
    paramsMap.put("manufacturer", Build.MANUFACTURER);
    return APIManager.registerUnregisterDeviceForIntegrationVerification
        (mContext, API, paramsMap);
  }

  @Override public String getTaskTag() {
    return TAG_INTEGRATION_VERIFICATION_NETWORK_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

  public enum TASK_TYPE {
    REGISTER_DEVICE, UNREGISTER_DEVICE
  }

  private void createResult(APIResponse apiResponse) {
    mTaskResult.setPayload(apiResponse);
  }
}
