package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

import java.util.HashMap;

/**
 * Makes a device add call on fresh installation
 * Service constant MSG_DEVICE_ADD
 *
 * @author Umang Chamaria
 */
public class DeviceAddTask extends SDKTask {

  private static final String TAG = "DeviceAddTask";
  private String requestTime;
  private String batchId;


  public DeviceAddTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    Logger.v(TAG + " execution started");
    try {
      JSONObject body = MoEUtils.deviceInfo(mContext);
      if (body == null) {
        body = new JSONObject();
      }
      JSONObject metaJSON = getSDKMeta();
      if (metaJSON != null) {
        body.put(MoEConstants.ATTR_SDK_META, metaJSON);
      }
      String appId = MoEUtils.getAppId(mContext);
      if (TextUtils.isEmpty(appId)){
        Logger.e(TAG + " execute: Cannot make device add call, app id not present.");
        mTaskResult.setIsSuccess(false);
        return mTaskResult;
      }
      String endpoint = MoEConstants.API_ENDPOINT_DEVICE_ADD + "/" + appId;
      String requestId = MoEUtils.getSha1ForString(batchId
          + requestTime
          + ConfigurationProvider.getInstance(mContext).getCurrentUserId());
      HashMap<String, String> headers = new HashMap<>();
      headers.put(MoEConstants.REQUEST_HEADER_REQUEST_ID, requestId);
      if (APIManager.addDevice(mContext, body, endpoint, headers)) {
        ConfigurationProvider.getInstance(mContext).setDeviceRegistered(true);
        MoEUtils.saveCurrentExponentialCounter(mContext, 1);
        MoEDispatcher.getInstance(mContext).cancelRegistrationFallback();
        mTaskResult.setIsSuccess(true);
      }
    } catch (Exception e) {
      Logger.e(TAG + " execute() : ");
    }
    Logger.v(TAG + " execution completed");
    return mTaskResult;
  }

  @Override public String getTaskTag() {
    return TAG_DEVICE_ADD;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

  private JSONObject getSDKMeta() {
    try {
      JSONObject metaJSON = new JSONObject();
      batchId = MoEUtils.getBatchId();
      metaJSON.put(MoEConstants.ATTR_BATCH_ID, batchId);
      requestTime = MoEUtils.getCurrentISOTime();
      metaJSON.put(MoEConstants.REQUEST_ATTR_REQUEST_TIME, requestTime);

      ConfigurationProvider provider = ConfigurationProvider.getInstance(mContext);
      JSONObject preferences = new JSONObject();
      preferences.put(MoEConstants.REQUEST_ATTR_PUSH_PREFERENCE,
          !provider.isPushNotificationOptedOut());
      preferences.put(MoEConstants.REQUEST_ATTR_IN_APP_PREFERENCE, !provider.isInAppOptedOut());
      preferences.put(MoEConstants.REQUEST_ATTR_DATA_TRACKING_PREFERENCE,
          !provider.isDataTrackingOptedOut());
      if (preferences.length() != 0) {
        metaJSON.put(MoEConstants.REQUEST_ATTR_DEVICE_PREFERENCE, preferences);
      }
      if (metaJSON.length() != 0) {
        return metaJSON;
      }
    } catch (Exception e) {
      Logger.f(TAG + " getSDKMeta() ", e);
    }
    return null;
  }
}
