/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.remoteconfig;

import android.content.Context;
import com.moengage.core.APIResponse;
import com.moengage.core.ApiResponseUtility;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.RemoteConfiguration;
import com.moengage.core.remoteconfig.RemoteConfigResponseParser;

class RemoteConfigResponseHandler {
    private static final String TAG = "RemoteConfigResponseHandler";
    private RemoteConfigResponseParser responseParser = new RemoteConfigResponseParser();

    RemoteConfigResponseHandler() {
    }

    boolean handleConfigApiResponse(Context context, APIResponse response) {
        try {
            if (!ApiResponseUtility.isValidResponse(response)) {
                Logger.e("RemoteConfigResponseHandler handleConfigApiResponse() : Not a valid api response ");
                return false;
            }
            RemoteConfiguration remoteConfiguration = this.responseParser.parseConfigApiResponse(response);
            if (remoteConfiguration != null) {
                MoEDAO.getInstance(context).addOrUpdateRemoteConfiguration(remoteConfiguration);
            }
            MoEDAO.getInstance(context).updateConfigApiSyncTime(MoEUtils.currentTime());
            return true;
        }
        catch (Exception e) {
            Logger.f("RemoteConfigResponseHandler handleConfigApiResponse() : ");
            return false;
        }
    }
}

