package com.moengage.core.model;

import android.support.annotation.Nullable;
import com.moengage.core.remoteconfig.RemoteConfigDefault;
import java.util.List;

/**
 * @author Umang Chamaria
 */
public class RemoteConfiguration {
  private boolean logEntryStatus;
  @Nullable
  private String logEntryToken;
  private long pushAmpSyncDelay;
  @Nullable
  private List<String> blacklistedEventList;
  private boolean appStatus;
  private boolean inAppStatus;
  private boolean geofenceStatus;
  private boolean pushAmpStatus;
  private int eventBatchCount;
  private long dataSyncRetryInterval;
  @Nullable
  private List<String> flushEventList;
  private boolean periodicFlushStatus;
  private long  periodicFlushTime;
  private long pushAmpCampaignExpiryTime;
  private boolean realTimeTriggerStatus;
  private long realTimeTriggerSyncTime;
  @Nullable
  private List<String> gdprWhitelistEventList;
  private boolean trackingAppExitStatus;
  private long userAttributeCachingTime;

  public RemoteConfiguration(){
    logEntryStatus = RemoteConfigDefault.LOG_ENTRY_STATUS;
    logEntryToken = RemoteConfigDefault.LOG_ENTRY_TOKEN;
    pushAmpSyncDelay = RemoteConfigDefault.PUSH_AMP_SYNC_INTERVAL;
    appStatus = RemoteConfigDefault.ACCOUNT_STATUS;
    inAppStatus = RemoteConfigDefault.IN_APP_STATUS;
    geofenceStatus = RemoteConfigDefault.GEO_FENCE_STATUS;
    pushAmpStatus = RemoteConfigDefault.PUSH_AMP_STATUS;
    eventBatchCount = RemoteConfigDefault.EVENT_BATCH_COUNT;
    dataSyncRetryInterval = RemoteConfigDefault.DATA_SYNC_RETRY_INTERVAL;
    periodicFlushStatus = RemoteConfigDefault.PERIODIC_FLUSH_STATE;
    periodicFlushTime = RemoteConfigDefault.PERIODIC_FLUSH_TIME;
    pushAmpCampaignExpiryTime = RemoteConfigDefault.PUSH_AMP_CAMPAIGN_EXPIRY_TIME;
    realTimeTriggerStatus = RemoteConfigDefault.REAL_TIME_TRIGGER_STATUS;
    realTimeTriggerSyncTime = RemoteConfigDefault.REAL_TIME_TRIGGER_SYNC_INTERVAL;
    trackingAppExitStatus = RemoteConfigDefault.APP_EXIT_TRACKING_STATUS;
    userAttributeCachingTime = RemoteConfigDefault.USER_ATTRIBUTE_CACHING_TIME;
  }

  public boolean isLogEntryEnabled() {
    return logEntryStatus;
  }

  public void setLogEntryStatus(boolean logEntryStatus) {
    this.logEntryStatus = logEntryStatus;
  }

  @Nullable public String getLogEntryToken() {
    return logEntryToken;
  }

  public void setLogEntryToken(@Nullable String logEntryToken) {
    this.logEntryToken = logEntryToken;
  }

  public long getPushAmpSyncDelay() {
    return pushAmpSyncDelay;
  }

  public void setPushAmpSyncDelay(long pushAmpSyncDelay) {
    this.pushAmpSyncDelay = pushAmpSyncDelay;
  }

  @Nullable public List<String> getBlacklistedEventList() {
    return blacklistedEventList;
  }

  public void setBlacklistedEventList(@Nullable List<String> blacklistedEventList) {
    this.blacklistedEventList = blacklistedEventList;
  }

  public boolean isAppEnabled() {
    return appStatus;
  }

  public void setAppStatus(boolean appStatus) {
    this.appStatus = appStatus;
  }

  public boolean isInAppEnabled() {
    return inAppStatus;
  }

  public void setInAppStatus(boolean inAppStatus) {
    this.inAppStatus = inAppStatus;
  }

  public boolean isGeofenceEnabled() {
    return geofenceStatus;
  }

  public void setGeofenceStatus(boolean geofenceStatus) {
    this.geofenceStatus = geofenceStatus;
  }

  public boolean isPushAmpEnabled() {
    return pushAmpStatus;
  }

  public void setPushAmpStatus(boolean pushAmpStatus) {
    this.pushAmpStatus = pushAmpStatus;
  }

  public int getEventBatchCount() {
    return eventBatchCount;
  }

  public void setEventBatchCount(int eventBatchCount) {
    this.eventBatchCount = eventBatchCount;
  }

  public long getDataSyncRetryInterval() {
    return dataSyncRetryInterval;
  }

  public void setDataSyncRetryInterval(long dataSyncRetryInterval) {
    this.dataSyncRetryInterval = dataSyncRetryInterval;
  }

  @Nullable public List<String> getFlushEventList() {
    return flushEventList;
  }

  public void setFlushEventList(@Nullable List<String> flushEventList) {
    this.flushEventList = flushEventList;
  }

  public boolean isPeriodicFlushEnabled() {
    return periodicFlushStatus;
  }

  public void setPeriodicFlushStatus(boolean periodicFlushStatus) {
    this.periodicFlushStatus = periodicFlushStatus;
  }

  public long getPeriodicFlushTime() {
    return periodicFlushTime;
  }

  public void setPeriodicFlushTime(long periodicFlushTime) {
    this.periodicFlushTime = periodicFlushTime;
  }

  public long getPushAmpCampaignExpiryTime() {
    return pushAmpCampaignExpiryTime;
  }

  public void setPushAmpCampaignExpiryTime(long pushAmpCampaignExpiryTime) {
    this.pushAmpCampaignExpiryTime = pushAmpCampaignExpiryTime;
  }

  public boolean isRealTimeTriggerEnabled() {
    return realTimeTriggerStatus;
  }

  public void setRealTimeTriggerStatus(boolean realTimeTriggerStatus) {
    this.realTimeTriggerStatus = realTimeTriggerStatus;
  }

  public long getRealTimeTriggerSyncTime() {
    return realTimeTriggerSyncTime;
  }

  public void setRealTimeTriggerSyncTime(long realTimeTriggerSyncTime) {
    this.realTimeTriggerSyncTime = realTimeTriggerSyncTime;
  }

  @Nullable public List<String> getGdprWhitelistEventList() {
    return gdprWhitelistEventList;
  }

  public void setGdprWhitelistEventList(@Nullable List<String> gdprWhitelistEventList) {
    this.gdprWhitelistEventList = gdprWhitelistEventList;
  }

  public boolean isTrackingAppExitEnabled() {
    return trackingAppExitStatus;
  }

  public void setTrackingAppExitStatus(boolean trackingAppExitStatus) {
    this.trackingAppExitStatus = trackingAppExitStatus;
  }

  public long getUserAttributeCachingTime() {
    return userAttributeCachingTime;
  }

  public void setUserAttributeCachingTime(long userAttributeCachingTime) {
    this.userAttributeCachingTime = userAttributeCachingTime;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    RemoteConfiguration that = (RemoteConfiguration) o;

    if (logEntryStatus != that.logEntryStatus) return false;
    if (pushAmpSyncDelay != that.pushAmpSyncDelay) return false;
    if (appStatus != that.appStatus) return false;
    if (inAppStatus != that.inAppStatus) return false;
    if (geofenceStatus != that.geofenceStatus) return false;
    if (pushAmpStatus != that.pushAmpStatus) return false;
    if (eventBatchCount != that.eventBatchCount) return false;
    if (dataSyncRetryInterval != that.dataSyncRetryInterval) return false;
    if (periodicFlushStatus != that.periodicFlushStatus) return false;
    if (periodicFlushTime != that.periodicFlushTime) return false;
    if (pushAmpCampaignExpiryTime != that.pushAmpCampaignExpiryTime) return false;
    if (realTimeTriggerStatus != that.realTimeTriggerStatus) return false;
    if (realTimeTriggerSyncTime != that.realTimeTriggerSyncTime) return false;
    if (trackingAppExitStatus != that.trackingAppExitStatus) return false;
    if (userAttributeCachingTime != that.userAttributeCachingTime) return false;
    if (logEntryToken != null ? !logEntryToken.equals(that.logEntryToken)
        : that.logEntryToken != null) {
      return false;
    }
    if (blacklistedEventList != null ? !blacklistedEventList.equals(that.blacklistedEventList)
        : that.blacklistedEventList != null) {
      return false;
    }
    if (flushEventList != null ? !flushEventList.equals(that.flushEventList)
        : that.flushEventList != null) {
      return false;
    }
    return gdprWhitelistEventList != null ? gdprWhitelistEventList.equals(
        that.gdprWhitelistEventList) : that.gdprWhitelistEventList == null;
  }

  @Override public int hashCode() {
    return 0;
  }
}
