package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEAttribute;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

class SetAliasTask extends SDKTask{

  private JSONObject aliasJSON;

  SetAliasTask(Context context, JSONObject aliasJSON){
    super(context);
    this.aliasJSON = aliasJSON;
  }

  @Override public TaskResult execute(){
    try{
      Logger.v("SetAliasTask: executing alias task");
      MoEAttribute aliasAttribute = MoEUtils.convertJsonToAttributeObject(aliasJSON);
      String savedUniqueId = MoEUtils.getUserAttributeUniqueId(mContext);
      if (savedUniqueId == null || aliasAttribute == null){
        MoEDispatcher.getInstance(mContext).getAttributeManager().setUserAttribute(aliasJSON);
        return null;
      }
      if (savedUniqueId.equals(aliasAttribute.getValue())){
        Logger.v("SetAliasTask: execute() current unique id same as same existing no need to "
            + "update");
        return null;
      }
      MoEDAO.getInstance(mContext).saveUserAttributeUniqueId(aliasAttribute);
      aliasJSON.put(MoEHelperConstants.USER_ID_MODIFIED_FROM, savedUniqueId);
      Event event = new Event(
          MoEHelperUtils.getDatapointJSON(MoEConstants.EVENT_ACTION_USER_ATTRIBUTE, aliasJSON));
      MoEDispatcher.getInstance(mContext).writeDataPointToStorage(event);
      Logger.v("SetAliasTask: completed alias task");
    } catch(Exception e){
      Logger.v("SetAliasTask: execute() ", e);
    }
    return null;
  }

  @Override public String getTaskTag(){
    return TAG_SET_ALIAS;
  }

  @Override public boolean isSynchronous(){
    return true;
  }
}
