package com.moengage.core;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

/**
 * @author Umang Chamaria
 */
public class ApiResponseUtility {
  private static final String TAG = "ApiResponseUtility";

  public static boolean isValidResponse(APIResponse response) {
    if (response == null) return false;
    if (response.responseCode != 200) return false;
    return response.responseBody != null;
  }

  @Nullable public static List<String> jsonArrayToStringList(JSONArray jsonArray) {
    try {
      if (jsonArray == null) return null;
      List<String> stringList = new ArrayList<>();
      for (int i = 0; i< jsonArray.length(); i++){
        String s = jsonArray.getString(i);
        if (!TextUtils.isEmpty(s)) {
          stringList.add(s);
        }
      }
      return stringList;
    } catch (Exception e) {
      Logger.f( TAG + " jsonArrayToStringList() : Exception ", e);
    }
    return null;
  }
}
