/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

public class DeviceAddTask
extends SDKTask {
    private static final String TAG = "DeviceAddTask";

    public DeviceAddTask(Context context) {
        super(context);
    }

    @Override
    public TaskResult execute() {
        Logger.v("DeviceAddTask execution started");
        try {
            String endpoint;
            JSONObject metaJSON;
            JSONObject body = MoEUtils.deviceInfo(this.mContext);
            if (body == null) {
                body = new JSONObject();
            }
            if ((metaJSON = this.getSDKMeta()) != null) {
                body.put("meta", (Object)metaJSON);
            }
            if (APIManager.addDevice(this.mContext, body, endpoint = "/v2/device/add/" + MoEUtils.getAppId(this.mContext))) {
                ConfigurationProvider.getInstance(this.mContext).setDeviceRegistered(true);
                MoEUtils.saveCurrentExponentialCounter(this.mContext, 1);
                MoEDispatcher.getInstance(this.mContext).cancelRegistrationFallback();
                this.mTaskResult.setIsSuccess(true);
            }
        }
        catch (Exception e) {
            Logger.e("DeviceAddTask execute() : ");
        }
        Logger.v("DeviceAddTask execution completed");
        return this.mTaskResult;
    }

    @Override
    public String getTaskTag() {
        return "DEVICE_ADD";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private JSONObject getSDKMeta() {
        try {
            JSONObject metaJSON = new JSONObject();
            ConfigurationProvider provider = ConfigurationProvider.getInstance(this.mContext);
            JSONObject preferences = new JSONObject();
            preferences.put("push_p", !provider.isPushNotificationOptedOut());
            preferences.put("in_app_p", !provider.isInAppOptedOut());
            preferences.put("e_t_p", !provider.isDataTrackingOptedOut());
            if (preferences.length() != 0) {
                metaJSON.put("dev_pref", (Object)preferences);
            }
            if (metaJSON.length() != 0) {
                return metaJSON;
            }
        }
        catch (Exception e) {
            Logger.f("DeviceAddTask getSDKMeta() ", e);
        }
        return null;
    }
}

