package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

/**
 * Track device attributes. This intentionally uses the user attribute table since there are very
 * device attributes as of now.
 *
 * @author Umang Chamaria
 */

class SetDeviceAttributeTask extends SDKTask{
  private JSONObject mDeviceAttribute;

  SetDeviceAttributeTask(@NonNull Context context, @NonNull JSONObject deviceAttribute){
    super(context);
    mDeviceAttribute = deviceAttribute;
  }

  @Override public TaskResult execute(){
    Logger.v("SetDeviceAttributeTask: executing Task");
    UserAttribute currentUserAttribute = MoEUtils.getUserAttributePoJo(mDeviceAttribute);
    UserAttribute savedUserAttribute = null;
    if (currentUserAttribute != null){
      savedUserAttribute =
          MoEUtils.getSavedUserAttribute(mContext, currentUserAttribute.userAttributeName);
    }
    if (MoEUtils.shouldSendUserAttribute(currentUserAttribute, savedUserAttribute)){
      Logger.d(
          "SetDeviceAttributeTask : setUserAttribute User attribute not yet sent to server will "
              + "send : "
              + mDeviceAttribute.toString());
      Event event = new Event(
          MoEHelperUtils.getDatapointJSON(MoEConstants.EVENT_ACTION_DEVICE_ATTRIBUTE,
              mDeviceAttribute));
      MoEDispatcher.getInstance(mContext).writeDataPointToStorage(event);
      MoEDAO.getInstance(mContext).addOrUpdateUserAttribute(currentUserAttribute);
      mTaskResult.setIsSuccess(true);
    } else{
      Logger.d(
          "SetDeviceAttributeTask : setUserAttributes already sent once, need not send duplicate "
              + "attribute : "
              + mDeviceAttribute.toString());
      mTaskResult.setIsSuccess(false);
    }
    Logger.v("SetDeviceAttributeTask: completed Task");
    return mTaskResult;
  }

  @Override public String getTaskTag(){
    return TAG_SET_DEVICE_ATTRIBUTES;
  }

  @Override public boolean isSynchronous(){
    return false;
  }
}
