/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.segmentation;

import android.support.annotation.Nullable;
import android.text.format.DateUtils;
import android.text.format.Time;
import com.moengage.core.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FilterEvaluator {
    private static final String TAG = "FilterEvaluator";
    private JSONObject mEventAttributes;
    private JSONObject mConditions;
    private String mAttributeName;
    private String mOperator;
    private String mDataType;
    private Object mValue;
    private boolean mNegate;
    private boolean mCaseSensitive;

    public FilterEvaluator(JSONObject conditions, JSONObject eventAttributes) {
        this.mEventAttributes = eventAttributes;
        this.mConditions = conditions;
        try {
            this.mNegate = this.mConditions.optBoolean("negate", false);
            this.mCaseSensitive = this.mConditions.optBoolean("case_sensitive", false);
            this.mDataType = this.mConditions.getString("data_type");
            this.mOperator = this.mConditions.getString("operator");
            this.mAttributeName = this.mConditions.getString("name");
            if (this.mConditions.has("value")) {
                this.mValue = this.mConditions.get("value");
            }
        }
        catch (Exception e) {
            Logger.f("FilterEvaluatorFilterEvaluator() : ", e);
        }
    }

    public boolean evaluate() {
        try {
            if (this.mAttributeName == null || this.mOperator == null || this.mDataType == null) {
                return false;
            }
            if (this.mOperator.equals("exists")) {
                boolean result = this.checkIfAttributesHasAttribute();
                if (this.mNegate) {
                    return !result;
                }
                return result;
            }
            if (!this.checkIfAttributesHasAttribute()) {
                return false;
            }
            switch (this.mDataType) {
                case "bool": {
                    return this.isConditionSatisfiedBoolean();
                }
                case "double": {
                    return this.isConditionSatisfiedDouble();
                }
                case "string": {
                    return this.isConditionSatisfiedString();
                }
                case "datetime": {
                    return this.isConditionSatisfiedDateTime();
                }
            }
        }
        catch (Exception e) {
            Logger.f("FilterEvaluatorevaluate() : ", e);
        }
        return false;
    }

    private boolean isConditionSatisfiedString() {
        block39: {
            try {
                Object userValue = this.getAttributeValue();
                boolean result = false;
                if (userValue == null || this.mValue == null) {
                    return false;
                }
                if (this.mOperator.equals("contains")) {
                    String campaignValueString = (String)this.mValue;
                    if (!this.mCaseSensitive) {
                        campaignValueString = campaignValueString.toLowerCase();
                    }
                    if (userValue instanceof JSONArray) {
                        JSONArray userValueArray = (JSONArray)userValue;
                        for (int i = 0; i < userValueArray.length(); ++i) {
                            if (!userValueArray.getString(i).contains((String)this.mValue)) continue;
                            result = true;
                            break;
                        }
                        if (this.mNegate) {
                            return !result;
                        }
                        return result;
                    }
                    if (userValue instanceof String) {
                        String userValueString = (String)userValue;
                        if (!this.mCaseSensitive) {
                            userValueString = userValueString.toLowerCase();
                            campaignValueString = campaignValueString.toLowerCase();
                        }
                        result = userValueString.contains(campaignValueString);
                        if (this.mNegate) {
                            return !result;
                        }
                        return result;
                    }
                    return false;
                }
                if (this.mOperator.equals("in")) {
                    JSONArray campaignValueArray = (JSONArray)this.mValue;
                    if (campaignValueArray == null) {
                        return false;
                    }
                    if (userValue instanceof JSONArray) {
                        JSONArray userValueArray = (JSONArray)userValue;
                        for (int i = 0; i < campaignValueArray.length(); ++i) {
                            boolean shouldBreak = false;
                            for (int j = 0; j < userValueArray.length(); ++j) {
                                String userString = userValueArray.getString(j);
                                String campaignString = campaignValueArray.getString(i);
                                if (!this.mCaseSensitive) {
                                    userString = userString.toLowerCase();
                                    campaignString = campaignString.toLowerCase();
                                }
                                if (!userString.equals(campaignString)) continue;
                                shouldBreak = true;
                                result = true;
                                break;
                            }
                            if (shouldBreak) break;
                        }
                        if (this.mNegate) {
                            return !result;
                        }
                        return result;
                    }
                    if (userValue instanceof String) {
                        String userValueString = (String)userValue;
                        if (!this.mCaseSensitive) {
                            userValueString = userValueString.toLowerCase();
                        }
                        for (int i = 0; i < campaignValueArray.length(); ++i) {
                            String campaignValueString = campaignValueArray.getString(i);
                            if (!this.mCaseSensitive) {
                                campaignValueString = campaignValueString.toLowerCase();
                            }
                            if (!campaignValueString.equals(userValueString)) continue;
                            result = true;
                            break;
                        }
                        if (this.mNegate) {
                            return !result;
                        }
                        return result;
                    }
                    break block39;
                }
                if (!(userValue instanceof String) || !(this.mValue instanceof String)) {
                    return false;
                }
                String campaignValueString = (String)this.mValue;
                String userValueString = (String)userValue;
                if (!this.mCaseSensitive) {
                    userValueString = userValueString.toLowerCase();
                    campaignValueString = campaignValueString.toLowerCase();
                }
                if (userValueString == null || campaignValueString == null) {
                    return false;
                }
                switch (this.mOperator) {
                    case "is": {
                        result = userValueString.equals(campaignValueString);
                        if (this.mNegate) {
                            return !result;
                        }
                        return result;
                    }
                    case "endsWith": {
                        result = userValueString.endsWith(campaignValueString);
                        if (this.mNegate) {
                            return !result;
                        }
                        return result;
                    }
                    case "startsWith": {
                        result = userValueString.startsWith(campaignValueString);
                        if (this.mNegate) {
                            return !result;
                        }
                        return result;
                    }
                }
                return false;
            }
            catch (Exception e) {
                Logger.f("FilterEvaluatorisConditionSatisfiedString() : ", e);
            }
        }
        return false;
    }

    private boolean checkIfAttributesHasAttribute() throws JSONException {
        String eventAttrString;
        JSONObject eventAttr;
        if (this.mEventAttributes.has("EVENT_ATTRS") && (eventAttr = new JSONObject(eventAttrString = this.mEventAttributes.getString("EVENT_ATTRS"))).has(this.mAttributeName)) {
            return true;
        }
        if (this.mEventAttributes.has("EVENT_ATTRS_CUST")) {
            try {
                String eventCustAttrString = this.mEventAttributes.getString("EVENT_ATTRS_CUST");
                JSONObject customAttributes = new JSONObject(eventCustAttrString);
                if (!customAttributes.has("timestamp")) {
                    return false;
                }
                JSONArray customAttr = customAttributes.getJSONArray("timestamp");
                if (customAttr == null) {
                    return false;
                }
                for (int i = 0; i < customAttr.length(); ++i) {
                    JSONObject attr2 = customAttr.getJSONObject(i);
                    if (!attr2.has(this.mAttributeName)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                Logger.f("FilterEvaluatorcheckIfAttributesHasAttribute() : ", e);
                return false;
            }
        }
        return false;
    }

    private boolean isConditionSatisfiedDateTime() throws JSONException, ParseException {
        Object userValue = this.getAttributeValue();
        if (userValue == null) {
            return false;
        }
        if (this.mValue == null && !this.mOperator.equals("today")) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        long campaignDate = 0L;
        if (this.mValue != null) {
            campaignDate = format.parse((String)this.mValue).getTime();
        }
        long userDate = (Long)userValue;
        switch (this.mOperator) {
            case "on": {
                Time time = new Time();
                time.set(campaignDate);
                int thenYear = time.year;
                int thenMonth = time.month;
                int thenMonthDay = time.monthDay;
                time.set(userDate);
                return thenYear == time.year && thenMonth == time.month && thenMonthDay == time.monthDay;
            }
            case "between": {
                boolean result;
                if (!this.mConditions.has("value1")) {
                    return false;
                }
                String upperBound = this.mConditions.getString("value1");
                long upperBoundDate = format.parse(upperBound).getTime();
                boolean bl = result = userDate >= campaignDate && userDate < upperBoundDate;
                if (this.mNegate) {
                    return !result;
                }
                return result;
            }
            case "before": {
                return campaignDate > userDate;
            }
            case "after": {
                return userDate > campaignDate;
            }
            case "today": {
                return DateUtils.isToday((long)userDate);
            }
        }
        return false;
    }

    private boolean isConditionSatisfiedBoolean() throws JSONException {
        Object userValue = this.getAttributeValue();
        if (userValue == null || this.mValue == null) {
            return false;
        }
        boolean userValueBoolean = (Boolean)userValue;
        boolean campaignValueBoolean = (Boolean)this.mValue;
        switch (this.mOperator) {
            case "is": {
                boolean result;
                boolean bl = result = userValueBoolean == campaignValueBoolean;
                if (this.mNegate) {
                    return !result;
                }
                return result;
            }
        }
        return false;
    }

    private boolean isConditionSatisfiedDouble() throws JSONException {
        Object userValue = this.getAttributeValue();
        if (userValue == null) {
            return false;
        }
        boolean result = false;
        if (this.mOperator.equals("in")) {
            if (!(this.mValue instanceof JSONArray)) {
                return false;
            }
            JSONArray campaignValueArray = (JSONArray)this.mValue;
            if (userValue instanceof JSONArray) {
                JSONArray userValueArray = (JSONArray)userValue;
                for (int i = 0; i < campaignValueArray.length(); ++i) {
                    boolean shouldBreak = false;
                    for (int j = 0; j < userValueArray.length(); ++j) {
                        if (userValueArray.getDouble(j) != campaignValueArray.getDouble(i)) continue;
                        shouldBreak = true;
                        result = true;
                        break;
                    }
                    if (shouldBreak) break;
                }
                if (this.mNegate) {
                    return !result;
                }
                return result;
            }
            double userValueDouble = Double.parseDouble(userValue.toString());
            for (int i = 0; i < campaignValueArray.length(); ++i) {
                if (userValueDouble != campaignValueArray.getDouble(i)) continue;
                result = true;
                break;
            }
            if (this.mNegate) {
                return !result;
            }
            return result;
        }
        double userValueLong = Double.parseDouble(userValue.toString());
        double campaignValueLong = Double.parseDouble(this.mValue.toString());
        switch (this.mOperator) {
            case "is": {
                boolean bl = result = userValueLong == campaignValueLong;
                if (this.mNegate) {
                    return !result;
                }
                return result;
            }
            case "greaterThan": {
                return userValueLong > campaignValueLong;
            }
            case "lessThan": {
                return userValueLong < campaignValueLong;
            }
            case "between": {
                if (!this.mConditions.has("value1")) {
                    return false;
                }
                double upperBound = this.mConditions.getDouble("value1");
                boolean bl = result = userValueLong >= campaignValueLong && userValueLong < upperBound;
                if (this.mNegate) {
                    return !result;
                }
                return result;
            }
        }
        return false;
    }

    @Nullable
    private Object getAttributeValue() throws JSONException {
        String eventAttrString;
        JSONObject eventAttr;
        if (this.mEventAttributes.has("EVENT_ATTRS") && (eventAttr = new JSONObject(eventAttrString = this.mEventAttributes.getString("EVENT_ATTRS"))).has(this.mAttributeName)) {
            return eventAttr.get(this.mAttributeName);
        }
        if (this.mEventAttributes.has("EVENT_ATTRS_CUST")) {
            String eventCustAttrString = this.mEventAttributes.getString("EVENT_ATTRS_CUST");
            JSONObject customAttributes = new JSONObject(eventCustAttrString);
            JSONArray customAttr = customAttributes.getJSONArray("timestamp");
            for (int i = 0; i < customAttr.length(); ++i) {
                JSONObject attr2 = customAttr.getJSONObject(i);
                if (!attr2.has(this.mAttributeName)) continue;
                return attr2.get(this.mAttributeName);
            }
        }
        return null;
    }
}

