/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.core;

import android.Manifest;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.APIFailedException;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.MoERestClient.RequestMethod;
import com.moengage.inapp.InAppController;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * This class is responsible for all interactions with the MoE servers.
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 5.0
 */
public final class APIManager {

  private APIManager() {
    // Constructor intentionally made private. Utility class cannot be
    // instantiated
  }

  /*
   * Makes a device add call to the backend
   *
   * @param con Instance of the Application {@link Context}
   * @return true if device add was successful false otherwise
   */
  static boolean addDevice(Context con, JSONObject body, String endpoint) {
    Logger.v("APIManager:Sending GCM Client ID to server");
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled()) return false;
      MoERestClient client =
          new MoERestClient(MoEUtils.getAPIRoute(con) + endpoint, con);
      if (body != null) {
        client.addBody(body);
      }
      client.execute(RequestMethod.POST);
      return isHttpStatusOk(client.getResponseCode());
    } catch (UnsupportedEncodingException e) {
      Logger.f("APIManager:registerDevice", e);
    } catch (IOException e) {
      Logger.f("APIManager:registerDevice", e);
    } catch (SDKNotInitializedException e) {
      Logger.f("APIManager:registerDevice", e);
    } catch (Exception e) {
      Logger.f("APIManager:registerDevice", e);
    }
    return false;
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @param interactionData The interaction data collected by the SDK
   * @return true if the report add was successful.
   * @throws APIFailedException
   */
  static boolean sendInteractionReport(Context con, JSONObject interactionData, String endpoint){
    Logger.v("APIManager:Sending interaction report ");
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled()) return false;
      MoERestClient client =
          new MoERestClient(MoEUtils.getAPIRoute(con) + endpoint, con);
      client.addBody(interactionData);
      client.execute(RequestMethod.POST);
      return parseReportAddResponse(client.getResponseCode());
    } catch (UnsupportedEncodingException e) {
      Logger.f("APIManager: sendInteractionReport: UnsupportedEncodingException", e);
    } catch (IOException e) {
      Logger.f("APIManager: sendInteractionReport: IOException", e);
    } catch (SDKNotInitializedException e) {
      Logger.f("APIManager: sendInteractionReport", e);
    } catch (Exception e) {
      Logger.f("APIManager: sendInteractionReport", e);
    }
    return false;
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @param API API to trigger
   * @param paramsMap Body of API
   */
  @Nullable static String getGeoFences(Context con, String API,
      HashMap<String, String> paramsMap) {
    Logger.v("APIManager: getGeoFences: Get geo fences");
    if ((MoEHelperUtils.hasPermission(con, Manifest.permission.ACCESS_FINE_LOCATION)
        || MoEHelperUtils.hasPermission(con, Manifest.permission.ACCESS_COARSE_LOCATION))) {
      try {
        if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider
            .getInstance(con).isGeoEnabled()) return null;
        MoERestClient client = new MoERestClient(API, con);
        client.addParam(paramsMap);
        client.execute(MoERestClient.RequestMethod.POST);
        if (!isHttpStatusOk(client.getResponseCode())) {
          return null;
        }
        if (isValidAPIResponse(client.getResponse())) {
          return client.getResponse();
        }
      } catch (UnsupportedEncodingException e) {
        Logger.f("APIManager: getGeoFences", e);
      } catch (Exception e) {
        Logger.f("APIManager: getGeoFences", e);
      }
    }
    return null;
  }

  /*
   * @param con Instance of the Application {@link Context}
   */
  static void geoFenceHit(Context con, String API, HashMap<String, String> paramsMap) {
    Logger.v("APIManager:Registering a Geofence hit");
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider
          .getInstance(con).isGeoEnabled()) return;
      MoERestClient client = new MoERestClient(API, con);
      client.addParam(paramsMap);
      client.execute(MoERestClient.RequestMethod.POST);
    } catch (UnsupportedEncodingException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (IOException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (SDKNotInitializedException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (Exception e) {
      Logger.f("APIManager: geoFenceHit", e);
    }
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @param paramsMap The last updated time for the local inapp cache
   * @param API API to trigger
   * @param requestBody Request Body
   * @return true if the fetch was successful
   */
  @Nullable static String fetchInAppCampaigns(Context con, String API,
      HashMap<String, String> paramsMap, JSONObject requestBody) {
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider
          .getInstance(con).isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, con);
      client.addParam(paramsMap);
      if (requestBody != null){
        client.addBody(requestBody);
      }
      client.execute(RequestMethod.POST);
      Logger.v("APIManager: Processing InApp Response - will parse and save data");
      if (!isHttpStatusOk(client.getResponseCode())) {
        InAppController.getInstance().trackAPIFailure(InAppController.SYNC_API_FAILURE);
        return null;
      }
      //update last updated time
      ConfigurationProvider.getInstance(con).setLastInappUpdateTime(System.currentTimeMillis());
      if (!TextUtils.isEmpty(client.getResponse())) {
        Logger.v("APIManager: fetchInAppCampaingn" + client.getResponse());
        return client.getResponse();
      }
    } catch (Exception e) {
      Logger.f("APIManager: fetchInAppCampaigns", e);
      InAppController.getInstance().trackAPIFailure(InAppController.SYNC_API_FAILURE);
    }
    return null;
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @return returns the InAppMessage which needs to be shown for this auto
   * trigger event. If no in app is received then returns null
   */
  @Nullable static String logASmartEvent(Context con, String API, HashMap<String, String> paramsMap,
      JSONObject requestBody) {
    try {
      if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider
          .getInstance(con).isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, con);
      client.addParam(paramsMap);
      if (requestBody != null) {
        client.addBody(requestBody);
      }
      client.execute(RequestMethod.POST);
      Logger.v("APIManager: Processing Smart event response");
      if (!isHttpStatusOk(client.getResponseCode())) {
        InAppController.getInstance().trackAPIFailure(InAppController.SMART_API_FAILURE);
        return null;
      }
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("APIManager: logASmartEvent", e);
      InAppController.getInstance().trackAPIFailure(InAppController.SMART_API_FAILURE);
    }
    return null;
  }

  @Nullable static String fetchSingleInApp(Context context, String API,
      HashMap<String, String> requestParams) {
    try {
      if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider
          .getInstance(context).isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, context);
      client.addParam(requestParams);
      client.execute(RequestMethod.POST);
      if (!isHttpStatusOk(client.getResponseCode())) {
        InAppController.getInstance().trackAPIFailure(InAppController.SINGLE_API_FAILURE);
        return null;
      }
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("APIManager: fetchInAppCampaigns", e);
      InAppController.getInstance().trackAPIFailure(InAppController.SINGLE_API_FAILURE);
    }
    return null;
  }

  static boolean uploadLogsToLogEntries(Context context, String api, JSONObject jsonObject) {
    try {
      if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider
          .getInstance(context).isLogEntryEnabled()) return false;
      String request = jsonObject.toString();
      Logger.v("API Manager : uploadLogsToLogEntries : URI " + api);
      Logger.v("API Manager : uploadLogsToLogEntries : request " + request);
      if (TextUtils.isEmpty(request)) return false;
      URL url = new URL(api);
      HttpsURLConnection httpsURLConnection = (HttpsURLConnection) url.openConnection();
      httpsURLConnection.setDoOutput(true);
      httpsURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
      httpsURLConnection.setRequestProperty("Content-type", "application/json");
      OutputStream output = httpsURLConnection.getOutputStream();
      output.write(request.getBytes("UTF-8"));
      output.close();
      Logger.v(
          "API Manager : uploadLogsToLogEntries : response" + httpsURLConnection.getResponseCode());
      return httpsURLConnection.getResponseCode() == 204;
    } catch (Exception e) {
      //e.printStackTrace();
    }
    return false;
  }

  @Nullable static String syncConfig(Context context, String API) {
    try {
      MoERestClient client = new MoERestClient(API, context);
      client.execute(RequestMethod.POST);
      if (!isHttpStatusOk(client.getResponseCode())) {
        return null;
      }
      ConfigurationProvider.getInstance(context).setLastConfigSyncTime(System.currentTimeMillis());
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("API Manager : syncConfig exception", e);
    }
    return null;
  }

  @Nullable
  static String fetchMessages(Context context, String API, HashMap<String, String> paramsMap) {
    try {
      if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider
          .getInstance(context).isInboxEnabled()) return null;
      MoERestClient client = new MoERestClient(API, context);
      client.addParam(paramsMap);
      client.execute(RequestMethod.POST);
      if (!isHttpStatusOk(client.getResponseCode())) return null;
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("API Manager : fetchMessages exception", e);
    }
    return null;
  }

  @Nullable
  static APIResponse registerUnregisterDeviceForIntegrationVerification(Context context, String API,
      HashMap<String, String> paramsMap) {
    try {
      if (!ConfigurationProvider.getInstance(context).isAppEnabled())return null;
      MoERestClient client = new MoERestClient(API, context);
      if (paramsMap != null) {
        client.addParam(paramsMap);
      }
      client.execute(RequestMethod.POST);
      return new APIResponse(client.getResponse(), client.getResponseCode());
    } catch (Exception e) {
      Logger.f("APIManager : registerUnregisterDeviceForIntegrationVerification :", e);
    }
    return null;
  }

  @Nullable
  public static APIResponse deviceTriggerSyncRequest(Context context, String API, HashMap<String,
      String> paramsMap, JSONObject requestBody){
    try {
      if (!ConfigurationProvider.getInstance(context).isDeviceTriggerEnabled()
          || !ConfigurationProvider.getInstance(context).isAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, context);
      if (paramsMap != null){
        client.addParam(paramsMap);
      }
      if (requestBody != null){
        client.addBody(requestBody);
      }
      client.execute(RequestMethod.POST);
      return new APIResponse(client.getResponse(), client.getResponseCode());
    } catch (Exception e) {
      Logger.f( "MoERestClient: deviceTriggerSyncRequest() : ");
    }
    return null;
  }

  /**
   * Check if HTTP call was successful
   *
   * @param responseCode The HTTP response code
   * @return true if http status code is 200
   */
  static boolean isHttpStatusOk(int responseCode) {
    return 200 == responseCode;
  }

  /**
   * Checks to see if the API returns a valid response
   * @throws JSONException
   */
  static boolean isValidAPIResponse(String response) throws JSONException {
    if (TextUtils.isEmpty(response)) return false;
    JSONObject jsonResponse = new JSONObject(response);
    String result = jsonResponse.getString(MoEConstants.RESPONSE_ATTR_RESULT);
    return MoEConstants.RESULT_OK.equals(result);
  }

  /**
   * Parse Report Add response
   * @throws APIFailedException
   */
  static boolean parseReportAddResponse(int responseCode) throws APIFailedException {
    if (!isHttpStatusOk(responseCode)) {
      throw new APIFailedException("Getting : " + responseCode);
    }
    return true;
  }

}
