/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.utils;

/**
 * A class containing all the Helper constants which the client app might need
 * to use.
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.2.0
 * @since 1.0
 */
public final class MoEHelperConstants {

  private MoEHelperConstants() {
    // Utility class contains only constants cannot be instantiated by dev
  }

  /**
   * The current lib version. If lib version is v5.0.0 then the value is 500
   */
  public static final int LIB_VERSION = 9201;
  /**
   * The User attribute name which denotes a unique attribute
   */
  public static final String USER_ATTRIBUTE_UNIQUE_ID = "USER_ATTRIBUTE_UNIQUE_ID";
  /**
   * The User attribute name which denotes the user email id
   */
  public static final String USER_ATTRIBUTE_USER_EMAIL = "USER_ATTRIBUTE_USER_EMAIL";
  /**
   * The User attribute name which denotes the user mobile number
   */
  public static final String USER_ATTRIBUTE_USER_MOBILE = "USER_ATTRIBUTE_USER_MOBILE";
  /**
   * The User attribute name which denotes the user name
   */
  public static final String USER_ATTRIBUTE_USER_NAME = "USER_ATTRIBUTE_USER_NAME";
  /**
   * The User attribute name which denotes the user gender
   */
  public static final String USER_ATTRIBUTE_USER_GENDER = "USER_ATTRIBUTE_USER_GENDER";
  /**
   * The User attribute name which denotes the user first name
   */
  public static final String USER_ATTRIBUTE_USER_FIRST_NAME = "USER_ATTRIBUTE_USER_FIRST_NAME";
  /**
   * The User attribute name which denotes the last name of the user
   */
  public static final String USER_ATTRIBUTE_USER_LAST_NAME = "USER_ATTRIBUTE_USER_LAST_NAME";

  public static final String USER_ATTRIBUTE_USER_LOCATION = "last_known_location";
  /**
   * The User attribute name which denotes the user birth date
   */
  public static final String USER_ATTRIBUTE_USER_BDAY = "USER_ATTRIBUTE_USER_BDAY";

  public static final String USER_ATTRIBUTE_NOTIFICATION_START = "USER_ATTRIBUTE_DND_START_TIME";

  public static final String USER_ATTRIBUTE_NOTIFICATION_END = "USER_ATTRIBUTE_DND_END_TIME";

  public static final String USER_ATTRIBUTE_ASSOCIATED_TIME_FORMAT = "MOE_TIME_FORMAT";

  public static final String USER_ATTRIBUTE_ASSOCIATED_TIMEZONE = "MOE_TIME_TIMEZONE";

  public static final String USER_ATTRIBUTE_NOTIFICATION_PREF = "USER_ATTRIBUTE_NOTIFICATION_PREF";

  /**
   * The User attribute value associated with
   * {@link #USER_ATTRIBUTE_USER_GENDER} representing a MALE user
   */
  public static final String GENDER_MALE = "male";
  /**
   * The User attribute value associated with
   * {@link #USER_ATTRIBUTE_USER_GENDER} representing a FEMALE user
   */
  public static final String GENDER_FEMALE = "female";
  /**
   * The GCM intent extra key which denotes that GCM payload was received from
   * MoEngage
   */
  public static final String GCM_EXTRA_CONFIRMATION_KEY = "push_from";
  /**
   * The GCM intent extra value which denotes that GCM payload was received
   * from MoEngage
   */
  public static final String GCM_EXTRA_CONFIRMATION_VALUE = "moengage";

  /**
   * The Registration ID as received as part of the GCM Registration Event
   */
  public static final String EXTRA_REGISTRATION_ID = "registration_id";

    /* ***************************** GCM PAYLOAD KEYs ************************************** */
  /**
   * Associated with the GCM Payload received from the MoEngage Platform.
   */
  public static final String GCM_EXTRA_UNIQUE_ID = "gcm_uniqueId";
  /**
   * Associated with the GCM Payload received from the MoEngage Platform.
   * Denotes that a dialog needs to be shown
   */
  public static final String GCM_EXTRA_SHOW_DIALOG = "gcm_show_dialog";
  /**
   * Associated with the GCM Payload. The notification title.
   */
  public static final String GCM_EXTRA_TITLE = "gcm_title";
  /**
   * Associated with the GCM Payload. The notification body
   */
  public static final String GCM_EXTRA_CONTENT = "gcm_alert";
  /**
   * Associated with the GCM Payload. An action to a notification.
   */
  public static final String GCM_EXTRA_ACTION = "gcm_action_title";
  /**
   * Associated with the GCM Payload. The Activity to open on notification
   * click
   */
  public static final String GCM_EXTRA_ACTIVITY_NAME = "gcm_activityName";
  /**
   * Associated with the GCM Payload. Denotes that the Notification opens a
   * web URL in a browser
   */
  public static final String GCM_EXTRA_WEB_NOTIFICATION = "gcm_webNotification";
  /**
   * Associated with the GCM Payload. Denotes the kind of notification we need
   * to show. Its Either {@link #GCM_EXTRA_WEB_NOTIFICATION},
   */
  public static final String GCM_EXTRA_NOTIFICATION_TYPE = "gcm_notificationType";
  /**
   * Associated with the GCM Payload. The URL to open for a
   * {@link #GCM_EXTRA_WEB_NOTIFICATION}
   */
  public static final String GCM_EXTRA_WEB_URL = "gcm_webUrl";
  /**
   * Associated with the GCM Payload. The campaign ID associated to this push
   * notification
   */
  public static final String GCM_EXTRA_CAMPAIGN_ID = "gcm_campaign_id";
  /**
   * Associated with the GCM Payload. The Geo ID associated to this user
   */
  public static final String GCM_EXTRA_GEO_ID = "gcm_geo_id";
  /**
   * Associated with the GCM Payload. The coupon code that the payload
   * contains.
   */
  public static final String GCM_EXTRA_COUPON_CODE = "gcm_coupon_code";
  /**
   * Associated with the GCM Payload. The Image that the notification has to
   * show
   */
  public static final String GCM_EXTRA_IMAGE_URL = "gcm_image_url";
  /**
   * An <B>intent extra</b> which is used to denote that the launched activity
   * was shown as a result of a notification getting clicked. It is also
   * associated with <b>event tracking</b> telling the server that a
   * notification was received and to increment the impression count
   */
  public static final String NOTIFICATION_RECEIVED_MOE = "NOTIFICATION_RECEIVED_MOE";
  /**
   * Associated with event tracking for notification being clicked
   */
  public static final String EVENT_NOTIFICATION_CLICKED = "NOTIFICATION_CLICKED_MOE";

  public static final String EVENT_NOTIFICATION_CLEARED = "NOTIFICATION_CLEARED_MOE";

  public static final String NAVIGATION_SOURCE_KEY = "nav_source";

  public static final String NAVIGATION_SOURCE_NOTIFICATION = "notification";

  public static final String NAVIGATION_PROVIDER_KEY = "nav_provier";

  public static final String NAVIGATION_PROVIDER_VALUE = "moengage";

  public static final String EVENT_APP_UPD = "UPDATE";

  public static final String EVENT_APP_INSTALL = "INSTALL";

  public static final String FROM_VERSION = "VERSION_FROM";

  public static final String TO_VERSION = "VERSION_TO";

  public static final String VERSION = "VERSION";

  public static final String TIME_OF_INSTALL = "INSTALLED_TIME";

  public static final String TIME_OF_UPDATE = "UPDATED_ON";

  /**
   * <b>Preference key</b>.The install referrer as obtained by the MoEngage
   * SDK
   */
  public static final String PREF_KEY_INSTALL_REFERRER = "INSTALL_REFERRER_MOE";

  public static final String EXTRA_IS_FROM_BACKGROUND = "FROM_BACKGROUND";

  /**
   * The Intent extra which tells the system when the notification was
   * received from the server
   */
  public static final String EXTRA_MSG_RECEIVED_TIME = "MOE_MSG_RECEIVED_TIME";

  public static final String EXTRA_CAMPAIGN_EXPIRED = "gcm_campaign_expired";

  /**
   * Delimiter for events in the list.
   */
  public static final String EVENT_SEPERATOR = ";";

  public static final String PREF_KEY_GEO_FENCE_LIST = "geo_list";

  public static final String WIDGET_ID = "widget_id";

  public static final String USER_ID_MODIFIED_FROM = "USER_ID_MODIFIED_FROM";

  public static final String USER_ATTRIBUTE_USER_PUSH_PREFERENCE = "USER_PUSH_PREFERENCE";

  public static final int MOE_REGION_INDIA = 1001;

  public static final int MOE_REGION_EU = 1002;

  public static final int MOE_REGION_DEFAULT = 1003;


  /**
   * Associated with event tracking for inapp message being shown
   */
  public static String EVENT_IN_APP_SHOWN = "IN_APP_SHOWN";
  /**
   * Associated with event tracking for in app message being clicked
   */
  public static String EVENT_IN_APP_CLICKED = "IN_APP_CLICKED";
  /**
   * Associated with event tracking when in-app is auto dismissed after the defined time
   */
  public static String EVENT_IN_APP_AUTO_DISMISS = "IN_APP_AUTO_DISMISS";
  /**
   * Associated with event tracking for in app message being explicitly closed
   * by use by clicking the close button
   */
  public static String EVENT_IN_APP_CLOSE_CLICKED = "IN_APP_CLOSE_CLICKED";

  public static String EVENT_GEO_FENCE_HIT = "MOE_GEOFENCE_HIT";

  public static String IN_APP_CHECK_FAILURE_EVENT = "IN_APP_CHECK_FAILURE";

  public static String EVENT_ACTION_WEB_ACTIVITY_CLICK = "EVENT_ACTION_WEB_ACTIVITY_CLICK";

  public static String NOTIFICATION_OFFLINE_MOE = "NOTIFICATION_OFFLINE_MOE";

  public static String DT_CAMPAIGN_SCHEDULED = "DT_CAMPAIGN_SCHEDULED";

  /**
   * Rating event
   */
  public static String APP_RATED_EVENT = "MOE_APP_RATED";

  public static final String TOKEN_EVENT = "TOKEN_EVENT";
}
