/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.Nullable;
import com.moe.pushlibrary.models.BatchData;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DataSyncJob;
import com.moengage.core.Logger;
import com.moengage.core.MoEAlarmReceiver;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.OnJobComplete;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.ArrayList;

class SendInteractionDataTask
extends SDKTask {
    private OnJobComplete jobCompleteCallback;
    private JobParameters jobParameters;
    private final String TAG = "SendInteractionDataTask";

    SendInteractionDataTask(Context context, @Nullable OnJobComplete jobCompleteCallback, @Nullable JobParameters parameters) {
        super(context);
        this.jobCompleteCallback = jobCompleteCallback;
        this.jobParameters = parameters;
    }

    @Override
    public TaskResult execute() {
        try {
            if (!ConfigurationProvider.getInstance(this.mContext).isAppEnabled()) {
                return null;
            }
            Logger.v("SendInteractionDataTask executing task");
            this.sendInteractionData();
            this.schedulePeriodicRetryIfRequired();
            this.releaseJobLockIfRequired();
            Logger.v("SendInteractionDataTask : completed task");
            return null;
        }
        catch (Exception e) {
            Logger.f("SendInteractionDataTask : execute() ", e);
            return null;
        }
    }

    private void releaseJobLockIfRequired() {
        if (Build.VERSION.SDK_INT >= 21 && this.jobCompleteCallback != null && this.jobParameters != null) {
            Logger.v("SendInteractionDataTask releaseJobLockIfRequired() : Trying to release job lock.");
            this.jobCompleteCallback.jobCompleted(this.jobParameters, false);
        }
    }

    @Override
    public String getTaskTag() {
        return "SEND_INTERACTION_DATA";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private void sendInteractionData() {
        boolean result = false;
        ArrayList<BatchData> batchedData = null;
        String endpoint = "/v2/report/add/" + MoEUtils.getAppId(this.mContext);
        if (this.shouldSendDataToTestServer()) {
            endpoint = "/integration/send_report_add_call";
        }
        while (true) {
            batchedData = MoEDAO.getInstance(this.mContext).getBatchedData(100);
            Logger.d("SendInteractionDataTask : sendInteractionData:Fetching interaction data in batches");
            if (batchedData == null || batchedData.isEmpty()) {
                Logger.d("SendInteractionDataTask : sendInteractionData: Found Nothing to send");
                return;
            }
            for (BatchData data : batchedData) {
                try {
                    result = APIManager.sendInteractionReport(this.mContext, data.batchData, endpoint);
                }
                catch (Exception e) {
                    Logger.f("SendInteractionDataTask : API failed", e);
                    result = false;
                }
                if (result) {
                    Logger.d("SendInteractionDataTask : Batch sent successfully deleting batch");
                    MoEDAO.getInstance(this.mContext).deleteBatch(data);
                    continue;
                }
                int retryCount = ConfigurationProvider.getInstance(this.mContext).getImmediateRetryCount();
                switch (retryCount) {
                    case 0: {
                        this.scheduleImmediateRetry(1);
                        ConfigurationProvider.getInstance(this.mContext).setImmediateRetryCount(++retryCount);
                        break;
                    }
                    case 1: {
                        this.scheduleImmediateRetry(3);
                        ConfigurationProvider.getInstance(this.mContext).setImmediateRetryCount(++retryCount);
                        break;
                    }
                    default: {
                        ConfigurationProvider.getInstance(this.mContext).setImmediateRetryCount(0);
                        break;
                    }
                }
                break;
            }
            if (!result) break;
            batchedData.clear();
        }
    }

    private boolean shouldSendDataToTestServer() {
        boolean isDeviceRegisteredForVerification = ConfigurationProvider.getInstance(this.mContext).isDeviceRegisteredForVerification();
        long registrationTime = ConfigurationProvider.getInstance(this.mContext).getVerificationRegistrationTime();
        return isDeviceRegisteredForVerification && registrationTime + 3600000L > System.currentTimeMillis();
    }

    private void scheduleRetryDataSyncAlarm() {
        Logger.v("Scheduling data sync retry");
        Intent alarmIntent = new Intent(this.mContext, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)88888, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        alarmManager.setInexactRepeating(0, System.currentTimeMillis() + ConfigurationProvider.getInstance(this.mContext).getRetrySyncTime(), ConfigurationProvider.getInstance(this.mContext).getRetrySyncTime(), pendingIntent);
    }

    @TargetApi(value=21)
    private void scheduleRetryDataSyncJob() {
        Logger.v("Scheduling retry data sync job");
        ComponentName serviceComponent = new ComponentName(this.mContext, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(77777, serviceComponent);
        builder.setRequiredNetworkType(1);
        builder.setOverrideDeadline(System.currentTimeMillis() + ConfigurationProvider.getInstance(this.mContext).getRetrySyncTime() * 2L);
        builder.setMinimumLatency(ConfigurationProvider.getInstance(this.mContext).getRetrySyncTime());
        JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
        jobScheduler.schedule(builder.build());
    }

    @TargetApi(value=21)
    private void scheduleImmediateRetrySyncJob(int minutes) {
        Logger.v("Scheduling immediate retry data sync job");
        ComponentName serviceComponent = new ComponentName(this.mContext, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(666666, serviceComponent);
        builder.setRequiredNetworkType(1);
        builder.setOverrideDeadline(System.currentTimeMillis() + (long)(minutes * 2 * 60 * 1000));
        builder.setMinimumLatency((long)(minutes * 60 * 1000));
        JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.schedule(builder.build());
        }
    }

    private void scheduleImmediateRetryAlarm(int minutes) {
        Intent alarmIntent = new Intent(this.mContext, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)55555, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, System.currentTimeMillis() + (long)(minutes * 60 * 1000), pendingIntent);
        }
    }

    private void scheduleImmediateRetry(int minutes) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.scheduleImmediateRetrySyncJob(minutes);
        } else {
            this.scheduleImmediateRetryAlarm(minutes);
        }
    }

    private void schedulePeriodicRetryIfRequired() {
        if (!ConfigurationProvider.getInstance(this.mContext).isBackgroundSyncEnabled()) {
            return;
        }
        Logger.v("SendInteractionDataTask schedulePeriodicRetryIfRequired() : Will schedule background retry.");
        if (Build.VERSION.SDK_INT >= 21) {
            this.scheduleRetryDataSyncJob();
        } else {
            this.scheduleRetryDataSyncAlarm();
        }
    }
}

