package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;


/**
 * @author Umang Chamaria
 */

class SetUserAttributeTask extends SDKTask{
  private JSONObject userJSON;
  private boolean shouldCacheUserAttribute;

  private static final String TAG = "SetUserAttributeTask";

  SetUserAttributeTask(@NonNull Context context, @NonNull JSONObject userJSON, boolean
      shouldCacheUserAttribute){
    super(context);
    this.userJSON = userJSON;
    this.shouldCacheUserAttribute = shouldCacheUserAttribute;
  }

  @Override public TaskResult execute(){
    if (ConfigurationProvider.getInstance(mContext).isDataTrackingOptedOut()){
      Logger.e(TAG + "execute() Data Tracking opted out cannot track user attribute " + userJSON
          .toString());
      mTaskResult.setIsSuccess(true);
      return mTaskResult;
    }
    Logger.v("SetUserAttributeTask: executing Task");
    UserAttribute currentUserAttribute = MoEUtils.getUserAttributePoJo(userJSON);
    UserAttribute savedUserAttribute = null;
    if (!shouldCacheUserAttribute){
      writeUserAttributeToStorage(currentUserAttribute);
    }else {
      if (currentUserAttribute != null){
        savedUserAttribute =
            MoEUtils.getSavedUserAttribute(mContext, currentUserAttribute.userAttributeName);
      }
      if (MoEUtils.shouldSendUserAttribute(currentUserAttribute, savedUserAttribute)){
        Logger.d("SetUserAttributeTask : setUserAttribute User attribute not yet sent to server will "
            + "send : "
            + userJSON.toString());
        if (currentUserAttribute != null && savedUserAttribute != null && currentUserAttribute.userAttributeName.equals(
            MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID)){
          MoEDispatcher.getInstance(mContext).handleLogout(true);
          return createTaskResult(userJSON, false);
        }
        writeUserAttributeToStorage(currentUserAttribute);
        MoEDAO.getInstance(mContext).addOrUpdateUserAttribute(currentUserAttribute);
        mTaskResult.setIsSuccess(true);
      } else{
        Logger.d(
            "SetUserAttributeTask : setUserAttributes already sent once, need not send duplicate "
                + "attribute : "
                + userJSON.toString());
        mTaskResult.setIsSuccess(true);
      }
    }
    Logger.v("SetUserAttributeTask: completed Task");
    return mTaskResult;
  }

  private void writeUserAttributeToStorage(@NonNull UserAttribute userAttribute) {
    if (userAttribute ==  null) return;
    Event event = new Event(
        MoEHelperUtils.getDatapointJSON(MoEConstants.EVENT_ACTION_USER_ATTRIBUTE, userJSON));
    MoEDispatcher.getInstance(mContext).writeDataPointToStorage(event);
  }

  @Override public String getTaskTag(){
    return TAG_SET_USER_ATTRIBUTES;
  }

  @Override public boolean isSynchronous(){
    return false;
  }
}