/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;

/**
 * This is a broadcast receiver for app Install broadcast. If you already have
 * an install receiver and still want to track installs on MoEngage platform
 * then call {@link #registerInstallation(Context, Intent)} from your own
 * install receiver
 * 
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 1.0
 */
public class InstallReceiver extends BroadcastReceiver{

	static final String REFERRER = "referrer";

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.content.BroadcastReceiver#onReceive(android.content.Context,
	 * android.content.Intent)
	 */
	@Override
	public void onReceive(final Context context, Intent intent) {
			Logger.v("InstallReceiver:client app does not use proxy");
		registerInstallation(context, intent);
	}


	/**
	 * Call this method to track installation from your proxy installation
	 * referrer.
	 *
	 * @param context
	 *            The Application {@link Context}
	 * @param intent
	 * 				The intent associated with the install referrer
	 */
	public static void registerInstallation(Context context, Intent intent){
		if( null == intent)return;
		Bundle extras = intent.getExtras();
		Logger.v("InstallReceiver:registerInstallation registering install event: ");
		//TODO start service and add user attribute
		if( null!= extras && extras.containsKey(REFERRER)){
			MoEHelperUtils.dumpIntentExtras(extras);
			String referrerString = extras.getString(REFERRER);
			if(!TextUtils.isEmpty(referrerString)){
				MoEHelperUtils.saveInstallReferrer(referrerString, context);
			}
		}
	}
}