/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.executor;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.TaskResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class TaskProcessor {
    private BlockingDeque<ITask> mTaskQueue;
    private ExecutorService mExecutorService = Executors.newCachedThreadPool();
    private ArrayList<WeakReference<OnTaskCompleteListener>> mTaskCompleteListeners;
    private ITask mActive;
    private final Object lock = new Object();
    private static TaskProcessor _INSTANCE = null;

    private TaskProcessor() {
        this.mTaskQueue = new LinkedBlockingDeque<ITask>();
        this.mTaskCompleteListeners = new ArrayList();
    }

    public static TaskProcessor getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new TaskProcessor();
        }
        return _INSTANCE;
    }

    public void addTask(ITask task) {
        if (task != null) {
            this.mTaskQueue.add(task);
            this.startExecution();
        }
    }

    public void addTaskToFront(ITask task) {
        if (task != null) {
            this.mTaskQueue.addFirst(task);
            this.startExecution();
        }
    }

    public void startExecution() {
        if (this.mActive == null) {
            this.scheduleNext();
        }
    }

    private void scheduleNext() {
        this.mActive = this.mTaskQueue.poll();
        if (this.mActive != null) {
            this.mExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    TaskProcessor.this.executeTask(TaskProcessor.this.mActive);
                    TaskProcessor.this.scheduleNext();
                }
            });
        }
    }

    private void executeTask(ITask task) {
        TaskResult result = task.execute();
        String action = task.getTaskTag();
        if (!TextUtils.isEmpty((CharSequence)action)) {
            this.notifyListener(action, result);
        }
        task.onPostExecute(result);
    }

    public void removeOnTaskCompleteListener(@NonNull OnTaskCompleteListener listener) {
        int index;
        if (this.mTaskCompleteListeners != null && listener != null && (index = this.mTaskCompleteListeners.indexOf(listener)) != -1) {
            this.mTaskCompleteListeners.remove(index);
        }
    }

    public void setOnTaskCompleteListener(OnTaskCompleteListener listener) {
        this.mTaskCompleteListeners.add(new WeakReference<OnTaskCompleteListener>(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListener(String tag, TaskResult result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTaskCompleteListeners != null) {
                for (WeakReference<OnTaskCompleteListener> taskCompleteListener : this.mTaskCompleteListeners) {
                    if (taskCompleteListener.get() == null) continue;
                    ((OnTaskCompleteListener)taskCompleteListener.get()).onTaskComplete(tag, result);
                }
            }
        }
    }
}

