/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.SetUserAttributeTask;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

class SetAliasTask
extends SDKTask {
    private JSONObject aliasJSON;

    SetAliasTask(Context context, JSONObject aliasJSON) {
        super(context);
        this.aliasJSON = aliasJSON;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("SetAliasTask: executing alias task");
            UserAttribute aliasAttribute = MoEUtils.getUserAttributePoJo(this.aliasJSON);
            UserAttribute savedUniqueId = MoEDAO.getInstance(this.mContext).getUserAttributesForKey("USER_ATTRIBUTE_UNIQUE_ID");
            if (savedUniqueId == null) {
                MoEDispatcher.getInstance(this.mContext).addTaskToQueue(new SetUserAttributeTask(this.mContext, this.aliasJSON, true));
                return null;
            }
            if (savedUniqueId.equals(aliasAttribute)) {
                Logger.v("SetAliasTask: execute() current unique id same as same existing no need to update");
                return null;
            }
            MoEDAO.getInstance(this.mContext).addOrUpdateUserAttribute(aliasAttribute);
            this.aliasJSON.put("USER_ID_MODIFIED_FROM", (Object)savedUniqueId.userAttributeValue);
            Event event = new Event(MoEHelperUtils.getDatapointJSON("EVENT_ACTION_USER_ATTRIBUTE", this.aliasJSON));
            MoEDispatcher.getInstance(this.mContext).writeDataPointToStorage(event);
            Logger.v("SetAliasTask: completed alias task");
        }
        catch (Exception e) {
            Logger.v("SetAliasTask: execute() ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "SET_ALIAS";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

