/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.job.JobParameters;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.OnJobComplete;
import com.moengage.core.SendInteractionDataTask;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

class CreatingDataBatchTask
extends SDKTask {
    private JobParameters jobParameters;
    private OnJobComplete jobComplete;

    CreatingDataBatchTask(Context context) {
        super(context);
    }

    CreatingDataBatchTask(Context context, @Nullable OnJobComplete jobComplete, @Nullable JobParameters parameters) {
        super(context);
        this.jobParameters = parameters;
        this.jobComplete = jobComplete;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("CreatingDataBatchTask: executing task");
            if (!ConfigurationProvider.getInstance(this.mContext).isAppEnabled()) {
                return null;
            }
            this.trackInstallReferrerIfRequired();
            this.createBatchRequests();
            MoEDispatcher.getInstance(this.mContext).addTaskToQueue(new SendInteractionDataTask(this.mContext, this.jobComplete, this.jobParameters));
            Logger.v("CreatingDataBatchTask: completed task execution");
        }
        catch (Exception e) {
            Logger.f("CreatingDataBatchTask: execute() ", e);
        }
        Logger.v("CreatingDataBatchTask: completed execution");
        return null;
    }

    private void trackInstallReferrerIfRequired() {
        String referrer = MoEHelperUtils.getInstallReferrer(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)referrer)) {
            JSONObject userJson = new JSONObject();
            try {
                userJson.put("INSTALL_REFERRER_MOE", (Object)referrer);
                MoEUtils.trackEventInternal("EVENT_ACTION_USER_ATTRIBUTE", userJson, this.mContext);
            }
            catch (Exception e) {
                Logger.f("SendInteractionDataTask:setUserAttribute", e);
            }
            MoEHelperUtils.removeInstallReferrer(this.mContext);
        }
    }

    @Override
    public String getTaskTag() {
        return "CREATE_DATA_BATCH";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private void createBatchRequests() {
        ArrayList<Event> batchedData = null;
        while (true) {
            batchedData = MoEDAO.getInstance(this.mContext).getInteractionData(100);
            Logger.d("CreatingDataBatchTask : createBatchRequests:Fetching interaction data in batches");
            if (batchedData == null || batchedData.isEmpty()) {
                Logger.d("CreatingDataBatchTask : createBatchRequests: Found Nothing to send");
                return;
            }
            String interactionData = this.convertEventsToJSON(batchedData);
            if (interactionData == null) {
                return;
            }
            MoEDAO.getInstance(this.mContext).writeBatch(interactionData);
            MoEDAO.getInstance(this.mContext).deleteInteractionData(batchedData, this.mContext);
            batchedData.clear();
        }
    }

    @Nullable
    private String convertEventsToJSON(ArrayList<Event> eventList) {
        if (eventList == null || eventList.isEmpty()) {
            return null;
        }
        JSONArray jsonInteractions = new JSONArray();
        for (Event event : eventList) {
            try {
                jsonInteractions.put((Object)new JSONObject(event.details));
            }
            catch (Exception e) {
                Logger.f("CreatingDataBatchTask:convertEventsToJSON", e);
            }
        }
        if (jsonInteractions.length() == 0) {
            return null;
        }
        JSONObject jsonInteractionsObject = new JSONObject();
        try {
            JSONObject sdkMeta;
            jsonInteractionsObject.put("viewsCount", jsonInteractions.length());
            jsonInteractionsObject.put("viewsInfo", (Object)jsonInteractions);
            JSONObject sdkIdentifiers = this.getSDKIdentifiersJSON();
            if (sdkIdentifiers != null) {
                jsonInteractionsObject.put("identifiers", (Object)sdkIdentifiers);
            }
            if ((sdkMeta = this.getSDKMeta()) != null) {
                jsonInteractionsObject.put("meta", (Object)sdkMeta);
            }
        }
        catch (Exception e) {
            Logger.f("CreatingDataBatchTask:convertEventsToJSON", e);
            return null;
        }
        return jsonInteractionsObject.toString();
    }

    @Nullable
    private JSONObject getSDKIdentifiersJSON() {
        try {
            String segmentAnonymousId;
            JSONObject identifierJSON = new JSONObject();
            UserAttribute userAttributeUniqueId = MoEDAO.getInstance(this.mContext).getUserAttributesForKey("USER_ATTRIBUTE_UNIQUE_ID");
            if (userAttributeUniqueId != null) {
                identifierJSON.put("moe_user_id", (Object)userAttributeUniqueId.userAttributeValue);
            }
            if (!TextUtils.isEmpty((CharSequence)(segmentAnonymousId = ConfigurationProvider.getInstance(this.mContext).getSegmentAnonymousId()))) {
                identifierJSON.put("segment_id", (Object)segmentAnonymousId);
            }
            if (identifierJSON.length() != 0) {
                return identifierJSON;
            }
        }
        catch (Exception e) {
            Logger.f("CreatingDataBatchTask: getSDKIdentifiersJSON() ", e);
        }
        return null;
    }

    @Nullable
    private JSONObject getSDKMeta() {
        try {
            JSONObject metaJSON = new JSONObject();
            String batchId = String.valueOf(System.currentTimeMillis()) + "-" + UUID.randomUUID().toString();
            metaJSON.put("bid", (Object)batchId);
            ConfigurationProvider provider = ConfigurationProvider.getInstance(this.mContext);
            JSONObject preferences = new JSONObject();
            if (provider.isPushNotificationOptedOut()) {
                preferences.put("push_p", !provider.isPushNotificationOptedOut());
            }
            if (provider.isInAppOptedOut()) {
                preferences.put("in_app_p", !provider.isInAppOptedOut());
            }
            if (provider.isDataTrackingOptedOut()) {
                preferences.put("e_t_p", !provider.isDataTrackingOptedOut());
            }
            if (preferences.length() != 0) {
                metaJSON.put("dev_pref", (Object)preferences);
            }
            if (metaJSON.length() != 0) {
                return metaJSON;
            }
        }
        catch (Exception e) {
            Logger.f("CreatingDataBatchTask: getSDKMeta() ", e);
        }
        return null;
    }
}

