/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.TaskStackBuilder;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.widget.Toast;
import com.delight.pushlibrary.R;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.push.PushManager;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionManagerBase {
    protected void handleActionCopy(Activity context, JSONObject actionObject) throws JSONException {
        Logger.v("ActionManagerBase$handleActionCopy");
        String message = "";
        if (actionObject.has("msg")) {
            message = actionObject.getString("msg");
        }
        if (actionObject.has("value")) {
            String value = actionObject.getString("value");
            MoEHelperUtils.copyCouponCodeToClipboard((Context)context, value, message);
        }
    }

    protected void handleActionCall(Activity context, JSONObject actionObject) throws JSONException {
        Logger.v("ActionManagerBase$handleActionCall");
        if (actionObject.has("value")) {
            String phoneNumber = actionObject.getString("value");
            if (!TextUtils.isEmpty((CharSequence)phoneNumber) && this.isPhoneNumberValid(phoneNumber)) {
                Intent callIntent = new Intent("android.intent.action.DIAL");
                callIntent.setData(Uri.parse((String)("tel:" + Uri.encode((String)phoneNumber))));
                context.startActivity(callIntent);
            } else {
                Toast.makeText((Context)context, (int)R.string.invalid_number, (int)1).show();
            }
        }
    }

    protected void handleActionShare(Activity context, JSONObject actionObject) throws JSONException {
        Logger.v("ActionManagerBase$handleActionShare");
        Intent sharingIntent = new Intent("android.intent.action.SEND");
        if (actionObject.has("content")) {
            String content = actionObject.getString("content");
            sharingIntent.setType("text/plain");
            sharingIntent.putExtra("android.intent.extra.TEXT", content);
            context.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)"Share via"));
        }
    }

    protected void handleActionNavigation(Activity context, JSONObject actionObject) throws JSONException, ClassNotFoundException {
        Logger.v("ActionManagerBase$handleActionNavigation");
        if (actionObject.has("screen")) {
            String screenName = actionObject.getString("screen");
            JSONObject extras = null;
            if (actionObject.has("extras")) {
                extras = actionObject.getJSONObject("extras");
            }
            Intent intent = new Intent((Context)context, Class.forName(screenName));
            if (extras != null) {
                intent.putExtras(MoEHelperUtils.convertJSONObjecttoBundle(extras));
            }
            if (!PushManager.getInstance().isBackStackBuilderOptedOut((Context)context)) {
                TaskStackBuilder builder = TaskStackBuilder.create((Context)context);
                builder.addNextIntentWithParentStack(intent).startActivities();
            } else {
                context.startActivity(intent);
            }
        } else if (actionObject.has("uri")) {
            Uri link = Uri.parse((String)actionObject.getString("uri"));
            Uri.Builder builder = link.buildUpon();
            Intent redirectIntent = new Intent("android.intent.action.VIEW", builder.build());
            context.startActivity(redirectIntent);
        }
    }

    private boolean isPhoneNumberValid(String phoneNumber) {
        for (int i = 0; i < phoneNumber.length(); ++i) {
            if (PhoneNumberUtils.isDialable((char)phoneNumber.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

