/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

class SetUserAttributeTask
extends SDKTask {
    private JSONObject userJSON;
    private boolean shouldCacheUserAttribute;
    private static final String TAG = "SetUserAttributeTask";

    SetUserAttributeTask(@NonNull Context context, @NonNull JSONObject userJSON, boolean shouldCacheUserAttribute) {
        super(context);
        this.userJSON = userJSON;
        this.shouldCacheUserAttribute = shouldCacheUserAttribute;
    }

    @Override
    public TaskResult execute() {
        if (ConfigurationProvider.getInstance(this.mContext).isDataTrackingOptedOut()) {
            Logger.e("SetUserAttributeTaskexecute() Data Tracking opted out cannot track user attribute " + this.userJSON.toString());
            this.mTaskResult.setIsSuccess(true);
            return this.mTaskResult;
        }
        Logger.v("SetUserAttributeTask: executing Task");
        UserAttribute currentUserAttribute = MoEUtils.getUserAttributePoJo(this.userJSON);
        UserAttribute savedUserAttribute = null;
        if (!this.shouldCacheUserAttribute) {
            this.writeUserAttributeToStorage(currentUserAttribute);
        } else {
            if (currentUserAttribute != null) {
                savedUserAttribute = MoEUtils.getSavedUserAttribute(this.mContext, currentUserAttribute.userAttributeName);
            }
            if (MoEUtils.shouldSendUserAttribute(currentUserAttribute, savedUserAttribute)) {
                Logger.d("SetUserAttributeTask : setUserAttribute User attribute not yet sent to server will send : " + this.userJSON.toString());
                if (currentUserAttribute != null && savedUserAttribute != null && currentUserAttribute.userAttributeName.equals("USER_ATTRIBUTE_UNIQUE_ID")) {
                    MoEDispatcher.getInstance(this.mContext).handleLogout(true);
                    return this.createTaskResult(this.userJSON, false);
                }
                this.writeUserAttributeToStorage(currentUserAttribute);
                MoEDAO.getInstance(this.mContext).addOrUpdateUserAttribute(currentUserAttribute);
                this.mTaskResult.setIsSuccess(true);
            } else {
                Logger.d("SetUserAttributeTask : setUserAttributes already sent once, need not send duplicate attribute : " + this.userJSON.toString());
                this.mTaskResult.setIsSuccess(true);
            }
        }
        Logger.v("SetUserAttributeTask: completed Task");
        return this.mTaskResult;
    }

    private void writeUserAttributeToStorage(@NonNull UserAttribute userAttribute) {
        if (userAttribute == null) {
            return;
        }
        Event event = new Event(MoEHelperUtils.getDatapointJSON("EVENT_ACTION_USER_ATTRIBUTE", this.userJSON));
        MoEDispatcher.getInstance(this.mContext).writeDataPointToStorage(event);
    }

    @Override
    public String getTaskTag() {
        return "SET_USER_ATTRIBUTES";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

