/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.APIResponse;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEParser;
import com.moengage.core.MoERestClient;
import com.moengage.core.MoEUtils;
import com.moengage.inapp.InAppController;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public final class APIManager {
    private APIManager() {
    }

    static boolean addDevice(Context con, JSONObject body, String endpoint) {
        Logger.v("APIManager:Sending GCM Client ID to server");
        try {
            if (!ConfigurationProvider.getInstance(con).isAppEnabled()) {
                return false;
            }
            MoERestClient client = new MoERestClient(MoEUtils.getAPIRoute(con) + endpoint, con, MoERestClient.API_VERSION.V2);
            if (body != null) {
                client.addBody(body.toString());
            }
            client.execute(MoERestClient.RequestMethod.POST);
            return MoEParser.isHttpStatusOk(client.getResponseCode());
        }
        catch (UnsupportedEncodingException e) {
            Logger.f("APIManager:registerDevice", e);
        }
        catch (IOException e) {
            Logger.f("APIManager:registerDevice", e);
        }
        catch (SDKNotInitializedException e) {
            Logger.f("APIManager:registerDevice", e);
        }
        catch (Exception e) {
            Logger.f("APIManager:registerDevice", e);
        }
        return false;
    }

    static boolean sendInteractionReport(Context con, String interactionData, String endpoint) {
        Logger.v("APIManager:Sending interaction report ");
        try {
            if (!ConfigurationProvider.getInstance(con).isAppEnabled()) {
                return false;
            }
            MoERestClient client = new MoERestClient(MoEUtils.getAPIRoute(con) + endpoint, con, MoERestClient.API_VERSION.V2);
            client.addBody(interactionData);
            client.execute(MoERestClient.RequestMethod.POST);
            return MoEParser.parseReportAddResponse(client.getResponseCode());
        }
        catch (UnsupportedEncodingException e) {
            Logger.f("APIManager: sendInteractionReport: UnsupportedEncodingException", e);
        }
        catch (IOException e) {
            Logger.f("APIManager: sendInteractionReport: IOException", e);
        }
        catch (SDKNotInitializedException e) {
            Logger.f("APIManager: sendInteractionReport", e);
        }
        catch (Exception e) {
            Logger.f("APIManager: sendInteractionReport", e);
        }
        return false;
    }

    @Nullable
    static String getGeoFences(Context con, String API, HashMap<String, String> paramsMap) {
        Logger.v("APIManager: getGeoFences: Get geo fences");
        if (MoEHelperUtils.hasPermission(con, "android.permission.ACCESS_FINE_LOCATION") || MoEHelperUtils.hasPermission(con, "android.permission.ACCESS_COARSE_LOCATION")) {
            try {
                if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider.getInstance(con).isGeoEnabled()) {
                    return null;
                }
                MoERestClient client = new MoERestClient(API, con, MoERestClient.API_VERSION.V1);
                client.addParam(paramsMap);
                client.execute(MoERestClient.RequestMethod.GET);
                if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
                    return null;
                }
                if (MoEParser.isValidAPIResponse(client.getResponse(), MoERestClient.API_VERSION.V1)) {
                    return client.getResponse();
                }
            }
            catch (UnsupportedEncodingException e) {
                Logger.f("APIManager: getGeoFences", e);
            }
            catch (Exception e) {
                Logger.f("APIManager: getGeoFences", e);
            }
        }
        return null;
    }

    static void geoFenceHit(Context con, String API, HashMap<String, String> paramsMap) {
        Logger.v("APIManager:Registering a Geofence hit");
        try {
            if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider.getInstance(con).isGeoEnabled()) {
                return;
            }
            MoERestClient client = new MoERestClient(API, con, MoERestClient.API_VERSION.V1);
            client.addParam(paramsMap);
            client.execute(MoERestClient.RequestMethod.GET);
        }
        catch (UnsupportedEncodingException e) {
            Logger.f("APIManager: geoFenceHit", e);
        }
        catch (IOException e) {
            Logger.f("APIManager: geoFenceHit", e);
        }
        catch (SDKNotInitializedException e) {
            Logger.f("APIManager: geoFenceHit", e);
        }
        catch (Exception e) {
            Logger.f("APIManager: geoFenceHit", e);
        }
    }

    @Nullable
    static String fetchInAppCampaigns(Context con, String API, HashMap<String, String> paramsMap, String requestBody) {
        try {
            if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider.getInstance(con).isInAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, con, MoERestClient.API_VERSION.V2);
            client.addParam(paramsMap);
            client.addBody(requestBody);
            client.execute(MoERestClient.RequestMethod.POST);
            Logger.v("APIManager: Processing InApp Response - will parse and save data");
            if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
                InAppController.getInstance().trackAPIFailure(InAppController.SYNC_API_FAILURE);
                return null;
            }
            ConfigurationProvider.getInstance(con).setLastInappUpdateTime(System.currentTimeMillis());
            if (!TextUtils.isEmpty((CharSequence)client.getResponse())) {
                Logger.v("APIManager: fetchInAppCampaingn" + client.getResponse());
                return client.getResponse();
            }
        }
        catch (Exception e) {
            Logger.f("APIManager: fetchInAppCampaigns", e);
            InAppController.getInstance().trackAPIFailure(InAppController.SYNC_API_FAILURE);
        }
        return null;
    }

    @Nullable
    static String logASmartEvent(Context con, String API, HashMap<String, String> paramsMap, String requestBody) {
        try {
            if (!ConfigurationProvider.getInstance(con).isAppEnabled() || !ConfigurationProvider.getInstance(con).isInAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, con, MoERestClient.API_VERSION.V2);
            client.addParam(paramsMap);
            client.addBody(requestBody);
            client.execute(MoERestClient.RequestMethod.POST);
            Logger.v("APIManager: Processing Smart event response");
            if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
                InAppController.getInstance().trackAPIFailure(InAppController.SMART_API_FAILURE);
                return null;
            }
            return client.getResponse();
        }
        catch (Exception e) {
            Logger.f("APIManager: logASmartEvent", e);
            InAppController.getInstance().trackAPIFailure(InAppController.SMART_API_FAILURE);
            return null;
        }
    }

    @Nullable
    static String fetchSingleInApp(Context context, String API, HashMap<String, String> requestParams) {
        try {
            if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider.getInstance(context).isInAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, context, MoERestClient.API_VERSION.V2);
            client.addParam(requestParams);
            client.execute(MoERestClient.RequestMethod.POST);
            if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
                InAppController.getInstance().trackAPIFailure(InAppController.SINGLE_API_FAILURE);
                return null;
            }
            return client.getResponse();
        }
        catch (Exception e) {
            Logger.f("APIManager: fetchInAppCampaigns", e);
            InAppController.getInstance().trackAPIFailure(InAppController.SINGLE_API_FAILURE);
            return null;
        }
    }

    static boolean uploadLogsToLogEntries(Context context, String api, JSONObject jsonObject) {
        try {
            if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider.getInstance(context).isLogEntryEnabled()) {
                return false;
            }
            String request = jsonObject.toString();
            Logger.v("API Manager : uploadLogsToLogEntries : URI " + api);
            Logger.v("API Manager : uploadLogsToLogEntries : request " + request);
            if (TextUtils.isEmpty((CharSequence)request)) {
                return false;
            }
            URL url = new URL(api);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
            httpsURLConnection.setRequestProperty("Content-type", "application/json");
            OutputStream output = httpsURLConnection.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.close();
            Logger.v("API Manager : uploadLogsToLogEntries : response" + httpsURLConnection.getResponseCode());
            return httpsURLConnection.getResponseCode() == 204;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nullable
    static String syncConfig(Context context, String API) {
        try {
            MoERestClient client = new MoERestClient(API, context, MoERestClient.API_VERSION.V2);
            client.execute(MoERestClient.RequestMethod.GET);
            if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
                return null;
            }
            ConfigurationProvider.getInstance(context).setLastConfigSyncTime(System.currentTimeMillis());
            return client.getResponse();
        }
        catch (Exception e) {
            Logger.f("API Manager : syncConfig exception", e);
            return null;
        }
    }

    @Nullable
    static String fetchMessages(Context context, String API, HashMap<String, String> paramsMap, String requestBody) {
        try {
            if (!ConfigurationProvider.getInstance(context).isAppEnabled() || !ConfigurationProvider.getInstance(context).isInboxEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, context, MoERestClient.API_VERSION.V2);
            client.addParam(paramsMap);
            client.addBody(requestBody);
            client.execute(MoERestClient.RequestMethod.GET);
            if (!MoEParser.isHttpStatusOk(client.getResponseCode())) {
                return null;
            }
            return client.getResponse();
        }
        catch (Exception e) {
            Logger.f("API Manager : fetchMessages exception", e);
            return null;
        }
    }

    static boolean registerUnregisterDeviceForIntegrationVerification(Context context, String API, HashMap<String, String> paramsMap) {
        try {
            if (!ConfigurationProvider.getInstance(context).isAppEnabled()) {
                return false;
            }
            MoERestClient client = new MoERestClient(API, context, MoERestClient.API_VERSION.V2);
            if (paramsMap != null) {
                client.addParam(paramsMap);
            }
            client.execute(MoERestClient.RequestMethod.GET);
            return MoEParser.isHttpStatusOk(client.getResponseCode());
        }
        catch (Exception e) {
            Logger.f("APIManager : registerUnregisterDeviceForIntegrationVerification :", e);
            return false;
        }
    }

    @Nullable
    public static APIResponse deviceTriggerSyncRequest(Context context, String API, HashMap<String, String> paramsMap, String requestBody) {
        try {
            if (!ConfigurationProvider.getInstance(context).isDeviceTriggerEnabled() || !ConfigurationProvider.getInstance(context).isAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, context, MoERestClient.API_VERSION.V2);
            if (paramsMap != null) {
                client.addParam(paramsMap);
            }
            if (!TextUtils.isEmpty((CharSequence)requestBody)) {
                client.addBody(requestBody);
            }
            client.execute(MoERestClient.RequestMethod.POST);
            return new APIResponse(client.getResponse(), client.getResponseCode());
        }
        catch (Exception e) {
            Logger.f("MoERestClient: deviceTriggerSyncRequest() : ");
            return null;
        }
    }
}

