package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.location.GeoManager;
import java.util.HashMap;

/**
 * API calls related to geo-fence
 *
 * @author Umang Chamaria
 */
public class GeoTask extends SDKTask {

  String API;
  private HashMap<String, String> paramsMap;
  private GeoManager.TASK_TYPE geoTask;

  public GeoTask(Context context, String API, HashMap<String, String> paramsMap,
      GeoManager.TASK_TYPE geoTask) {
    super(context);
    this.API = API;
    this.paramsMap = paramsMap;
    this.geoTask = geoTask;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v("GeoTask : executing task " + geoTask);
      if (!ConfigurationProvider.getInstance(mContext).isAppEnabled() || !ConfigurationProvider
          .getInstance(mContext).isGeoEnabled()) return null;
      switch (geoTask) {
        case GEOFENCE_HIT:
          APIManager.geoFenceHit(mContext, API, paramsMap);
          break;
        case GET_GEOFENCE:
          String response = APIManager.getGeoFences(mContext, API, paramsMap);
          if (!TextUtils.isEmpty(response)) {
            GeoManager.LocationHandler locationHandler =
                GeoManager.getInstance().getHandler(mContext);
            if (locationHandler != null) {
              locationHandler.setGeoFences(mContext, response);
            }
          }
          break;
        default:
          Logger.e("GeoTask : Unknown Task " + geoTask);
      }
      Logger.v("GeoTask : completed execution " + geoTask);
    } catch (Exception e) {
      Logger.f("GeoTask: execute() ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_GEO_TASK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
