package com.moe.pushlibrary.models;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author Umang Chamaria
 */
public class UserAttribute implements Parcelable{

  public String userAttributeName;
  public String userAttributeValue;

  public UserAttribute(){}
  public UserAttribute(String attributeName, String attributeValue){
    userAttributeName = attributeName;
    userAttributeValue = attributeValue;
  }
  protected UserAttribute(Parcel in) {
    readFromParcel(in);
  }

  public static final Creator<UserAttribute> CREATOR = new Creator<UserAttribute>() {
    @Override public UserAttribute createFromParcel(Parcel in) {
      return new UserAttribute(in);
    }

    @Override public UserAttribute[] newArray(int size) {
      return new UserAttribute[size];
    }
  };

  @Override public int describeContents() {
    return 0;
  }

  @Override public void writeToParcel(Parcel dest, int flags) {
    dest.writeString(userAttributeName);
    dest.writeString(userAttributeValue);
  }

  public void readFromParcel(Parcel in) {
    userAttributeName = in.readString();
    userAttributeValue = in.readString();
  }

  @Override public boolean equals(Object o) {
    if (o == null || !(o instanceof UserAttribute)) return false;
    UserAttribute userAttribute = (UserAttribute) o;
    return this.userAttributeName.equals(userAttribute.userAttributeName) && this
        .userAttributeValue.equals(userAttribute.userAttributeValue);
  }
}
