/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import org.json.JSONObject;

/**
 * Represents a tracking event
 * @author MoEngage (abhishek@moenegage.com)
 * @version 5.0
 * @since 5.0
 */
public class Event implements Parcelable {

	public long _id;
	public String details;
  public long gtime;
  public String eventName;

	public static final Parcelable.Creator<Event> CREATOR = new Parcelable.Creator<Event>() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see
		 * android.os.Parcelable.Creator#createFromParcel(android.os.Parcel)
		 */
		@Override
		public Event createFromParcel(Parcel source) {
			return new Event(source);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see android.os.Parcelable.Creator#newArray(int)
		 */
		@Override
		public Event[] newArray(int size) {
			return new Event[size];
		}

	};

	public Event() {
    this(-1, null);
	}

	public Event(int _id, String details) {
		this(_id, -1, details);
	}

  public Event(int _id, long gtime , String details){
    super();
    if( _id != -1){
      this._id = _id;
    }
    if( -1 != gtime ){
      this.gtime = gtime;
    }else{
      this.gtime = System.currentTimeMillis();
    }
    this.details = details;
  }

  public Event(String details){
    this( -1, details);
  }

	public Event(JSONObject details){
    this( -1, details.toString());
	}

	public Event(Parcel source) {
		readFromParcel(source);
	}

  public Event(String action, JSONObject attrs){
    this(MoEHelperUtils.getDatapointJSON(action, attrs));
		eventName = action;
  }

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeLong(_id);
		dest.writeString(details);
	}

	public void readFromParcel(Parcel in) {
		_id = in.readLong();
		details = in.readString();
	}
}
