package com.moengage.core.integrationVerification;

import android.app.ProgressDialog;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.TextView;
import com.delight.pushlibrary.R;

public class IntegrationVerificationActivity extends AppCompatActivity
    implements IntegrationVerificationContract.View {

  private ProgressDialog dialog;
  private TextView messageWidget;
  private TextView retryButtonWidget;
  private TextView unregisterButtonWidget;
  private IntegrationVerificationContract.Presenter presenter;

  @Override protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.activity_integration_verification);
    init();
    presenter = new IntegrationVerificationPresenter(getApplicationContext(), this);
    presenter.checkAndRestoreState();
  }

  private void init() {
    messageWidget = findViewById(R.id.message);
    retryButtonWidget = findViewById(R.id.retryButton);
    retryButtonWidget.setOnClickListener(new OnClickListener() {
      @Override public void onClick(View v) {
        presenter.registerDevice();
      }
    });
    unregisterButtonWidget = findViewById(R.id.unregisterButton);
    unregisterButtonWidget.setOnClickListener(new OnClickListener() {
      @Override public void onClick(View v) {
        presenter.unregisterDevice();
      }
    });
  }


  @Override protected void onStop() {
    super.onStop();
    dismissLoadingDialog();
  }

  @Override public void showLoadingDialog(String message) {
    dialog = ProgressDialog.show(IntegrationVerificationActivity.this, "", message, true);
  }

  @Override public void dismissLoadingDialog() {
    runOnUiThread(new Runnable() {
      @Override public void run() {
        if (dialog != null) {
          dialog.dismiss();
        }
      }
    });
  }

  @Override public void messageAndButton(final String message, final int buttonId) {
    runOnUiThread(new Runnable() {
      @Override public void run() {
        messageWidget.setText(message);
        messageWidget.setVisibility(View.VISIBLE);
        if (buttonId == R.id.unregisterButton){
          unregisterButtonWidget.setVisibility(View.VISIBLE);
          retryButtonWidget.setVisibility(View.GONE);
        }
        if (buttonId == R.id.retryButton){
          retryButtonWidget.setVisibility(View.VISIBLE);
          unregisterButtonWidget.setVisibility(View.GONE);
        }
      }
    });
  }
}
