package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
class SyncConfigAPITask extends SDKTask{
  private Context mContext;
  private ConfigurationProvider provider;

  SyncConfigAPITask(Context context){
    super(context);
    mContext = context;
    provider = ConfigurationProvider.getInstance(mContext);
  }

  @Override public TaskResult execute() {
    Logger.v("SyncConfigAPITask : executing Task");
    try {
      String response = APIManager.syncConfig(mContext,
          MoEUtils.getAPIRoute(mContext) + MoEConstants.API_ENDPOINT_CONFIG_API + MoEUtils.addDebugIfRequired(
              mContext, ConfigurationProvider.getInstance(mContext).getAppId()));
      if (!TextUtils.isEmpty(response)) {
        JSONObject responseJSON = new JSONObject(response);
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_LOG_ENTRY_STATUS)) {
          provider.setLogEntryEnable(
              getStateFromResponse(responseJSON, MoEConstants.RESPONSE_ATTR_LOG_ENTRY_STATUS));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_LOG_ENTRY_TOKEN)) {
          provider.setLogEntryKey(
              responseJSON.getString(MoEConstants.RESPONSE_ATTR_LOG_ENTRY_TOKEN));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_MESSAGE_SYNC)) {
          provider.setMessageFetchDelayDuration(responseJSON.getLong(MoEConstants
              .RESPONSE_ATTR_MESSAGE_SYNC) * 1000);
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_BLACKLIST_EVENT)) {
          JSONArray blackListEventsArray =
              responseJSON.getJSONArray(MoEConstants.RESPONSE_ATTR_BLACKLIST_EVENT);
          String eventLists = MoEUtils.convertJSONArrayToString(blackListEventsArray);
          provider.saveBlackListEventList(eventLists);
          MoEEventManager.getInstance(mContext).getBlackListedEvents();
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_APP_STATE)) {
          provider.saveAppState(
              getStateFromResponse(responseJSON, MoEConstants.RESPONSE_ATTR_APP_STATE));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_IN_APP_STATE)) {
          provider.saveInAppState(
              getStateFromResponse(responseJSON, MoEConstants.RESPONSE_ATTR_IN_APP_STATE));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_GEO_STATE)) {
          provider.saveGeoState(
              getStateFromResponse(responseJSON, MoEConstants.RESPONSE_ATTR_GEO_STATE));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_INBOX_STATE)) {
          provider.saveInboxState(
              getStateFromResponse(responseJSON, MoEConstants.RESPONSE_ATTR_INBOX_STATE));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_EVENT_SYNC_COUNT)) {
          provider.saveEventBatchCount(
              responseJSON.getInt(MoEConstants.RESPONSE_ATTR_EVENT_SYNC_COUNT));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL)){
          provider.setRetrySyncTime(
              responseJSON.getLong(MoEConstants.RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL) * 1000);
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_FLUSH_EVENTS)){
          String flushEvents = MoEUtils.convertJSONArrayToString(responseJSON.getJSONArray
              (MoEConstants.RESPONSE_ATTR_FLUSH_EVENTS));
          provider.saveFlushEventList(flushEvents);
          MoEEventManager.getInstance(mContext).getFlushEvents();
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_PERIODIC_FLUSH_STATE)){
          provider.savePeriodicFlushState(getStateFromResponse(responseJSON, MoEConstants
              .RESPONSE_ATTR_PERIODIC_FLUSH_STATE));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_PERIODIC_FLUSH_TIME)){
          provider.savePeriodicFlushTime(responseJSON.getLong(MoEConstants
              .RESPONSE_ATTR_PERIODIC_FLUSH_TIME));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY)){
          provider.saveCampaignIdTTL(responseJSON.getLong(MoEConstants
              .RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_DEVICE_TRIGGER_STATE)){
          provider.saveDeviceTriggerState(
              getStateFromResponse(responseJSON, MoEConstants.RESPONSE_ATTR_DEVICE_TRIGGER_STATE));
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_DEVICE_TRIGGER_SYNC_TIME)){
          provider.saveDTMinimumSyncDelay(responseJSON.getLong(MoEConstants
              .RESPONSE_ATTR_DEVICE_TRIGGER_SYNC_TIME) * 1000);
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_GDPR_WHITELIST_EVENTS)){
          String gdprWhiteListEvents = MoEUtils.convertJSONArrayToString(responseJSON.getJSONArray
              (MoEConstants.RESPONSE_ATTR_GDPR_WHITELIST_EVENTS));
          provider.saveGDPRWhiteListEventList(gdprWhiteListEvents);
          MoEEventManager.getInstance(mContext).getGDPRWhiteList();
        }
        if (responseJSON.has(MoEConstants.RESPONSE_ATTR_APP_EXIT_EVENT_TRACKING)) {
          provider.saveAppExitTrackingState(getStateFromResponse(responseJSON,
              MoEConstants.RESPONSE_ATTR_APP_EXIT_EVENT_TRACKING));
        }
      }
    } catch (Exception e) {
      Logger.f("SyncConfigAPITask : execute", e);
    }
    Logger.v("SyncConfigAPITask : execution completed");
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_SYNC_CONFIG_API;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

  private boolean getStateFromResponse(@NonNull JSONObject responseJSON,
      @NonNull String responseAttr) {
    try {
      String state = responseJSON.getString(responseAttr);
      switch (state) {
        case "blocked":
          return false;
        case "allowed":
          return true;
      }
    } catch (JSONException e) {
      Logger.f("SyncConfigAPITask: getStateFromResponse ", e);
    }
    return true;
  }
}
