/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEWorkerTask;

/**
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 1.0
 */
public class AppUpdateReceiver extends BroadcastReceiver{

	@Override
	public void onReceive(Context con, Intent intent) {
		try {
			if( null != intent ){
        String packageIntended = intent.getPackage();
        String thisPackage = con.getPackageName();
          MoEHelperUtils.dumpIntentExtras(intent);
          Logger.v("AppUpdateReceiver: received update intent for PackageIntended:"
                  + packageIntended
                  + " and it is listening for thisPackage: "
                  + thisPackage + " intent: "+ intent.toString());
        if(!TextUtils.isEmpty(packageIntended) && packageIntended.equals(thisPackage)){
          MoEDispatcher.getInstance(con).addTaskToQueue(new MoEWorkerTask(con, MoEConstants
              .SERVICE_TYPE_APP_UPDATE, null));
        }
      }
		} catch (Exception e) {
			Logger.f("AppUpdateReceiver: onReceive() ", e);
		}
	}

}
