package com.moengage.core;

import android.content.Context;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

/**
 * Makes a device add call on fresh installation
 * Service constant MSG_DEVICE_ADD
 *
 * @author Umang Chamaria
 */
public class DeviceAddTask extends SDKTask {

  private static final String TAG = "DeviceAddTask";

  public DeviceAddTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    Logger.v(TAG + " execution started");
    try {
      JSONObject body = MoEUtils.deviceInfo(mContext);
      if (body == null) {
        body = new JSONObject();
      }
      JSONObject metaJSON = getSDKMeta();
      if (metaJSON != null) {
        body.put(MoEConstants.ATTR_SDK_META, metaJSON);
      }

      if (APIManager.addDevice(mContext, body)) {
        ConfigurationProvider.getInstance(mContext).setDeviceRegistered(true);
        MoEUtils.saveCurrentExponentialCounter(mContext, 1);
        MoEDispatcher.getInstance(mContext).cancelRegistrationFallback();
        mTaskResult.setIsSuccess(true);
      }
    } catch (Exception e) {
      Logger.e(TAG + " execute() : ");
    }
    Logger.v(TAG + " execution completed");
    return mTaskResult;
  }

  @Override public String getTaskTag() {
    return TAG_DEVICE_ADD;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

  private JSONObject getSDKMeta() {
    try {
      JSONObject metaJSON = new JSONObject();

      ConfigurationProvider provider = ConfigurationProvider.getInstance(mContext);
      JSONObject preferences = new JSONObject();
      preferences.put(MoEConstants.REQUEST_ATTR_PUSH_PREFERENCE,
          !provider.isPushNotificationOptedOut());
      preferences.put(MoEConstants.REQUEST_ATTR_IN_APP_PREFERENCE, !provider.isInAppOptedOut());
      preferences.put(MoEConstants.REQUEST_ATTR_DATA_TRACKING_PREFERENCE,
          !provider.isDataTrackingOptedOut());
      if (preferences.length() != 0) {
        metaJSON.put(MoEConstants.REQUEST_ATTR_DEVICE_PREFERENCE, preferences);
      }

      if (metaJSON.length() != 0) {
        return metaJSON;
      }
    } catch (Exception e) {
      Logger.f("CreatingDataBatchTask: getSDKMeta() ", e);
    }
    return null;
  }
}
