/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.models;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author MoEngage (abhishek@moenegage.com)
 * @version 5.0
 * @since 5.0
 */
public class GeoLocation implements Parcelable {

	public double latitude;
	public double longitude;

	/**
	 * @param latitude
	 *            The latitude associated with the location
	 * @param longitude
	 *            The longitude associated with the location
	 */
	public GeoLocation(double latitude, double longitude) {
		super();
		this.latitude = latitude;
		this.longitude = longitude;
	}

	public GeoLocation(Parcel source) {
		readFromParcel(source);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.os.Parcelable#describeContents()
	 */
	@Override
	public int describeContents() {
		return 0;
	}

	public void readFromParcel(Parcel in) {
		latitude = in.readDouble();
		longitude = in.readDouble();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.os.Parcelable#writeToParcel(android.os.Parcel, int)
	 */
	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeDouble(latitude);
		dest.writeDouble(longitude);
	}

	public static final Parcelable.Creator<GeoLocation> CREATOR = new Parcelable.Creator<GeoLocation>() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see
		 * android.os.Parcelable.Creator#createFromParcel(android.os.Parcel)
		 */
		@Override
		public GeoLocation createFromParcel(Parcel source) {
			return new GeoLocation(source);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see android.os.Parcelable.Creator#newArray(int)
		 */
		@Override
		public GeoLocation[] newArray(int size) {
			return new GeoLocation[size];
		}
	};

	@Override public boolean equals(Object o) {
    if( null == o )return false;
		if( o instanceof GeoLocation){
      GeoLocation other = (GeoLocation)o;
      if( other.longitude == this.longitude && other.latitude == this.latitude ){
        return  true;
      }
    }
    return false;
	}
}
