/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.push;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import org.json.JSONObject;

public class MoEMessagingManager {
    private static MoEMessagingManager _INSTANCE = null;
    private MessagingHandler messagingHandler = null;

    private MoEMessagingManager() {
        this.loadHandler();
    }

    public static MoEMessagingManager getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new MoEMessagingManager();
        }
        return _INSTANCE;
    }

    private void loadHandler() {
        try {
            Class<?> handler = Class.forName("com.moengage.addon.messaging.MessagingHandlerImpl");
            this.messagingHandler = (MessagingHandler)handler.newInstance();
            Logger.v("MoEMessagingManager:loadHandler Messaging module Enabled");
        }
        catch (Exception e) {
            Logger.e("MoEMessagingManager : loadHandler : did not find supported module: " + e.getMessage());
        }
    }

    @Nullable
    public MessagingHandler getMessagingHandler(Context context) {
        if (ConfigurationProvider.getInstance(context).isInboxEnabled()) {
            return this.messagingHandler;
        }
        return null;
    }

    public static interface MessagingHandler {
        public void scheduleAndSyncMessages(Context var1);

        public void parsePayloadAndShowPush(Context var1, JSONObject var2);

        public void forceMessageSync(Context var1, boolean var2);

        public void scheduleMessageSync(Context var1);

        public void saveCampaignId(Context var1, String var2);
    }
}

