/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.integrationVerification;

import android.content.Context;
import android.os.Bundle;
import com.delight.pushlibrary.R;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.IntegrationVerificationNetworkCallTask;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.integrationVerification.IntegrationVerificationContract;

public class IntegrationVerificationPresenter
implements IntegrationVerificationContract.Presenter,
OnTaskCompleteListener {
    private Context context;
    private IntegrationVerificationContract.View view;

    public IntegrationVerificationPresenter(Context context, IntegrationVerificationContract.View view) {
        this.context = context;
        this.view = view;
        TaskProcessor.getInstance().setOnTaskCompleteListener(this);
    }

    @Override
    public void registerDevice() {
        MoEDispatcher.getInstance(this.context).addTaskToQueueBeginning(new IntegrationVerificationNetworkCallTask(this.context, IntegrationVerificationNetworkCallTask.TASK_TYPE.REGISTER_DEVICE));
        this.view.showLoadingDialog("Registering Device for Integration Verification");
    }

    @Override
    public void unregisterDevice() {
        MoEDispatcher.getInstance(this.context).addTaskToQueueBeginning(new IntegrationVerificationNetworkCallTask(this.context, IntegrationVerificationNetworkCallTask.TASK_TYPE.UNREGISTER_DEVICE));
        this.view.showLoadingDialog("Un-registering Device from Integration Verification");
    }

    @Override
    public void checkAndRestoreState() {
        MoEUtils.updateTestDeviceState(this.context);
        if (!ConfigurationProvider.getInstance(this.context).isDeviceRegisteredForVerification()) {
            this.registerDevice();
        } else {
            this.view.messageAndButton("Device is registered for Integration verification. Click on the button to un-register your device.", R.id.unregisterButton);
        }
    }

    @Override
    public void onTaskComplete(String tag, TaskResult taskResult) {
        switch (tag) {
            case "INTEGRATION_VERIFICATION_NETWORK_TASK": {
                Bundle result = (Bundle)taskResult.getPayload();
                this.view.dismissLoadingDialog();
                this.view.messageAndButton(result.getString("message"), result.getInt("button_id"));
            }
        }
    }
}

